// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the ClientGroup resource.
 */
public final class ClientGroupProvisioningState extends ExpandableStringEnum<ClientGroupProvisioningState> {
    /**
     * Static value Creating for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Succeeded for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleted for ClientGroupProvisioningState.
     */
    public static final ClientGroupProvisioningState DELETED = fromString("Deleted");

    /**
     * Creates a new instance of ClientGroupProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ClientGroupProvisioningState() {
    }

    /**
     * Creates or finds a ClientGroupProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ClientGroupProvisioningState.
     */
    public static ClientGroupProvisioningState fromString(String name) {
        return fromString(name, ClientGroupProvisioningState.class);
    }

    /**
     * Gets known ClientGroupProvisioningState values.
     * 
     * @return known ClientGroupProvisioningState values.
     */
    public static Collection<ClientGroupProvisioningState> values() {
        return values(ClientGroupProvisioningState.class);
    }
}
