// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Client Group operation.
 */
@Fluent
public final class ClientGroupsListResult implements JsonSerializable<ClientGroupsListResult> {
    /*
     * A collection of Client Group.
     */
    private List<ClientGroupInner> value;

    /*
     * A link for the next page of Client Group.
     */
    private String nextLink;

    /**
     * Creates an instance of ClientGroupsListResult class.
     */
    public ClientGroupsListResult() {
    }

    /**
     * Get the value property: A collection of Client Group.
     * 
     * @return the value value.
     */
    public List<ClientGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Client Group.
     * 
     * @param value the value value to set.
     * @return the ClientGroupsListResult object itself.
     */
    public ClientGroupsListResult withValue(List<ClientGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of Client Group.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of Client Group.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ClientGroupsListResult object itself.
     */
    public ClientGroupsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientGroupsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientGroupsListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientGroupsListResult.
     */
    public static ClientGroupsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientGroupsListResult deserializedClientGroupsListResult = new ClientGroupsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ClientGroupInner> value = reader.readArray(reader1 -> ClientGroupInner.fromJson(reader1));
                    deserializedClientGroupsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedClientGroupsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientGroupsListResult;
        });
    }
}
