// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Client operation.
 */
@Fluent
public final class ClientsListResult implements JsonSerializable<ClientsListResult> {
    /*
     * A collection of Client.
     */
    private List<ClientInner> value;

    /*
     * A link for the next page of Client.
     */
    private String nextLink;

    /**
     * Creates an instance of ClientsListResult class.
     */
    public ClientsListResult() {
    }

    /**
     * Get the value property: A collection of Client.
     * 
     * @return the value value.
     */
    public List<ClientInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Client.
     * 
     * @param value the value value to set.
     * @return the ClientsListResult object itself.
     */
    public ClientsListResult withValue(List<ClientInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of Client.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of Client.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ClientsListResult object itself.
     */
    public ClientsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientsListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientsListResult.
     */
    public static ClientsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientsListResult deserializedClientsListResult = new ClientsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ClientInner> value = reader.readArray(reader1 -> ClientInner.fromJson(reader1));
                    deserializedClientsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedClientsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientsListResult;
        });
    }
}
