// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ConnectionState information.
 */
@Fluent
public final class ConnectionState implements JsonSerializable<ConnectionState> {
    /*
     * Status of the connection.
     */
    private PersistedConnectionStatus status;

    /*
     * Description of the connection state.
     */
    private String description;

    /*
     * Actions required (if any).
     */
    private String actionsRequired;

    /**
     * Creates an instance of ConnectionState class.
     */
    public ConnectionState() {
    }

    /**
     * Get the status property: Status of the connection.
     * 
     * @return the status value.
     */
    public PersistedConnectionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the connection.
     * 
     * @param status the status value to set.
     * @return the ConnectionState object itself.
     */
    public ConnectionState withStatus(PersistedConnectionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description property: Description of the connection state.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the connection state.
     * 
     * @param description the description value to set.
     * @return the ConnectionState object itself.
     */
    public ConnectionState withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionsRequired property: Actions required (if any).
     * 
     * @return the actionsRequired value.
     */
    public String actionsRequired() {
        return this.actionsRequired;
    }

    /**
     * Set the actionsRequired property: Actions required (if any).
     * 
     * @param actionsRequired the actionsRequired value to set.
     * @return the ConnectionState object itself.
     */
    public ConnectionState withActionsRequired(String actionsRequired) {
        this.actionsRequired = actionsRequired;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("actionsRequired", this.actionsRequired);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionState if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionState.
     */
    public static ConnectionState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionState deserializedConnectionState = new ConnectionState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedConnectionState.status = PersistedConnectionStatus.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedConnectionState.description = reader.getString();
                } else if ("actionsRequired".equals(fieldName)) {
                    deserializedConnectionState.actionsRequired = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionState;
        });
    }
}
