// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A custom domain configuration that allows users to publish to their own domain name.
 */
@Fluent
public final class CustomDomainConfiguration implements JsonSerializable<CustomDomainConfiguration> {
    /*
     * Fully Qualified Domain Name (FQDN) for the custom domain.
     */
    private String fullyQualifiedDomainName;

    /*
     * Validation state for the custom domain. This is a read only property and is initially set to 'Pending' and will
     * be updated to 'Approved' by Event Grid only after ownership of the domain name has been successfully validated.
     */
    private CustomDomainValidationState validationState;

    /*
     * Identity info for accessing the certificate for the custom domain. This identity info must match an identity that
     * has been set on the namespace.
     */
    private CustomDomainIdentity identity;

    /*
     * The URL for the certificate that is used for publishing to the custom domain. We currently support certificates
     * stored in Azure Key Vault only. While certificate URL can be either
     * versioned URL of the following format
     * https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or unversioned URL of the
     * following format (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned certificate URL only (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert)
     */
    private String certificateUrl;

    /*
     * Expected DNS TXT record name. Event Grid will check for a TXT record with this name in the DNS record set of the
     * custom domain name to prove ownership over the domain.
     * The values under this TXT record must contain the expected TXT record value.
     */
    private String expectedTxtRecordName;

    /*
     * Expected DNS TXT record value. Event Grid will check for a TXT record with this value in the DNS record set of
     * the custom domain name to prove ownership over the domain.
     */
    private String expectedTxtRecordValue;

    /**
     * Creates an instance of CustomDomainConfiguration class.
     */
    public CustomDomainConfiguration() {
    }

    /**
     * Get the fullyQualifiedDomainName property: Fully Qualified Domain Name (FQDN) for the custom domain.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Set the fullyQualifiedDomainName property: Fully Qualified Domain Name (FQDN) for the custom domain.
     * 
     * @param fullyQualifiedDomainName the fullyQualifiedDomainName value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return this;
    }

    /**
     * Get the validationState property: Validation state for the custom domain. This is a read only property and is
     * initially set to 'Pending' and will be updated to 'Approved' by Event Grid only after ownership of the domain
     * name has been successfully validated.
     * 
     * @return the validationState value.
     */
    public CustomDomainValidationState validationState() {
        return this.validationState;
    }

    /**
     * Set the validationState property: Validation state for the custom domain. This is a read only property and is
     * initially set to 'Pending' and will be updated to 'Approved' by Event Grid only after ownership of the domain
     * name has been successfully validated.
     * 
     * @param validationState the validationState value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withValidationState(CustomDomainValidationState validationState) {
        this.validationState = validationState;
        return this;
    }

    /**
     * Get the identity property: Identity info for accessing the certificate for the custom domain. This identity info
     * must match an identity that has been set on the namespace.
     * 
     * @return the identity value.
     */
    public CustomDomainIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity info for accessing the certificate for the custom domain. This identity info
     * must match an identity that has been set on the namespace.
     * 
     * @param identity the identity value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withIdentity(CustomDomainIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the certificateUrl property: The URL for the certificate that is used for publishing to the custom domain. We
     * currently support certificates stored in Azure Key Vault only. While certificate URL can be either
     * versioned URL of the following format
     * https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or unversioned URL of the
     * following format (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned certificate URL only (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert).
     * 
     * @return the certificateUrl value.
     */
    public String certificateUrl() {
        return this.certificateUrl;
    }

    /**
     * Set the certificateUrl property: The URL for the certificate that is used for publishing to the custom domain. We
     * currently support certificates stored in Azure Key Vault only. While certificate URL can be either
     * versioned URL of the following format
     * https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or unversioned URL of the
     * following format (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned certificate URL only (e.g.,
     * https://contosovault.vault.azure.net/certificates/contosocert).
     * 
     * @param certificateUrl the certificateUrl value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    /**
     * Get the expectedTxtRecordName property: Expected DNS TXT record name. Event Grid will check for a TXT record with
     * this name in the DNS record set of the custom domain name to prove ownership over the domain.
     * The values under this TXT record must contain the expected TXT record value.
     * 
     * @return the expectedTxtRecordName value.
     */
    public String expectedTxtRecordName() {
        return this.expectedTxtRecordName;
    }

    /**
     * Set the expectedTxtRecordName property: Expected DNS TXT record name. Event Grid will check for a TXT record with
     * this name in the DNS record set of the custom domain name to prove ownership over the domain.
     * The values under this TXT record must contain the expected TXT record value.
     * 
     * @param expectedTxtRecordName the expectedTxtRecordName value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withExpectedTxtRecordName(String expectedTxtRecordName) {
        this.expectedTxtRecordName = expectedTxtRecordName;
        return this;
    }

    /**
     * Get the expectedTxtRecordValue property: Expected DNS TXT record value. Event Grid will check for a TXT record
     * with this value in the DNS record set of the custom domain name to prove ownership over the domain.
     * 
     * @return the expectedTxtRecordValue value.
     */
    public String expectedTxtRecordValue() {
        return this.expectedTxtRecordValue;
    }

    /**
     * Set the expectedTxtRecordValue property: Expected DNS TXT record value. Event Grid will check for a TXT record
     * with this value in the DNS record set of the custom domain name to prove ownership over the domain.
     * 
     * @param expectedTxtRecordValue the expectedTxtRecordValue value to set.
     * @return the CustomDomainConfiguration object itself.
     */
    public CustomDomainConfiguration withExpectedTxtRecordValue(String expectedTxtRecordValue) {
        this.expectedTxtRecordValue = expectedTxtRecordValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fullyQualifiedDomainName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property fullyQualifiedDomainName in model CustomDomainConfiguration"));
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fullyQualifiedDomainName", this.fullyQualifiedDomainName);
        jsonWriter.writeStringField("validationState",
            this.validationState == null ? null : this.validationState.toString());
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("certificateUrl", this.certificateUrl);
        jsonWriter.writeStringField("expectedTxtRecordName", this.expectedTxtRecordName);
        jsonWriter.writeStringField("expectedTxtRecordValue", this.expectedTxtRecordValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomainConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomainConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomDomainConfiguration.
     */
    public static CustomDomainConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainConfiguration deserializedCustomDomainConfiguration = new CustomDomainConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.fullyQualifiedDomainName = reader.getString();
                } else if ("validationState".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.validationState
                        = CustomDomainValidationState.fromString(reader.getString());
                } else if ("identity".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.identity = CustomDomainIdentity.fromJson(reader);
                } else if ("certificateUrl".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.certificateUrl = reader.getString();
                } else if ("expectedTxtRecordName".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.expectedTxtRecordName = reader.getString();
                } else if ("expectedTxtRecordValue".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.expectedTxtRecordValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomainConfiguration;
        });
    }
}
