// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
 */
public final class CustomDomainIdentityType extends ExpandableStringEnum<CustomDomainIdentityType> {
    /**
     * Static value SystemAssigned for CustomDomainIdentityType.
     */
    public static final CustomDomainIdentityType SYSTEM_ASSIGNED = fromString("SystemAssigned");

    /**
     * Static value UserAssigned for CustomDomainIdentityType.
     */
    public static final CustomDomainIdentityType USER_ASSIGNED = fromString("UserAssigned");

    /**
     * Creates a new instance of CustomDomainIdentityType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CustomDomainIdentityType() {
    }

    /**
     * Creates or finds a CustomDomainIdentityType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CustomDomainIdentityType.
     */
    public static CustomDomainIdentityType fromString(String name) {
        return fromString(name, CustomDomainIdentityType.class);
    }

    /**
     * Gets known CustomDomainIdentityType values.
     * 
     * @return known CustomDomainIdentityType values.
     */
    public static Collection<CustomDomainIdentityType> values() {
        return values(CustomDomainIdentityType.class);
    }
}
