// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Validation state for the custom domain. This is a read only property and is initially set to 'Pending' and will be
 * updated to 'Approved' by Event Grid only after ownership of the domain name has been successfully validated.
 */
public final class CustomDomainValidationState extends ExpandableStringEnum<CustomDomainValidationState> {
    /**
     * Static value Pending for CustomDomainValidationState.
     */
    public static final CustomDomainValidationState PENDING = fromString("Pending");

    /**
     * Static value Approved for CustomDomainValidationState.
     */
    public static final CustomDomainValidationState APPROVED = fromString("Approved");

    /**
     * Static value ErrorRetrievingDnsRecord for CustomDomainValidationState.
     */
    public static final CustomDomainValidationState ERROR_RETRIEVING_DNS_RECORD
        = fromString("ErrorRetrievingDnsRecord");

    /**
     * Creates a new instance of CustomDomainValidationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CustomDomainValidationState() {
    }

    /**
     * Creates or finds a CustomDomainValidationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CustomDomainValidationState.
     */
    public static CustomDomainValidationState fromString(String name) {
        return fromString(name, CustomDomainValidationState.class);
    }

    /**
     * Gets known CustomDomainValidationState values.
     * 
     * @return known CustomDomainValidationState values.
     */
    public static Collection<CustomDomainValidationState> values() {
        return values(CustomDomainValidationState.class);
    }
}
