// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the deadletter destination with resource identity.
 */
@Fluent
public final class DeadLetterWithResourceIdentity implements JsonSerializable<DeadLetterWithResourceIdentity> {
    /*
     * The identity to use when dead-lettering events.
     */
    private EventSubscriptionIdentity identity;

    /*
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during dead-lettering.
     */
    private DeadLetterDestination deadLetterDestination;

    /**
     * Creates an instance of DeadLetterWithResourceIdentity class.
     */
    public DeadLetterWithResourceIdentity() {
    }

    /**
     * Get the identity property: The identity to use when dead-lettering events.
     * 
     * @return the identity value.
     */
    public EventSubscriptionIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity to use when dead-lettering events.
     * 
     * @param identity the identity value to set.
     * @return the DeadLetterWithResourceIdentity object itself.
     */
    public DeadLetterWithResourceIdentity withIdentity(EventSubscriptionIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the deadLetterDestination property: Information about the destination where events have to be delivered for
     * the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during dead-lettering.
     * 
     * @return the deadLetterDestination value.
     */
    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    /**
     * Set the deadLetterDestination property: Information about the destination where events have to be delivered for
     * the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during dead-lettering.
     * 
     * @param deadLetterDestination the deadLetterDestination value to set.
     * @return the DeadLetterWithResourceIdentity object itself.
     */
    public DeadLetterWithResourceIdentity withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (deadLetterDestination() != null) {
            deadLetterDestination().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("deadLetterDestination", this.deadLetterDestination);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeadLetterWithResourceIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeadLetterWithResourceIdentity if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeadLetterWithResourceIdentity.
     */
    public static DeadLetterWithResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeadLetterWithResourceIdentity deserializedDeadLetterWithResourceIdentity
                = new DeadLetterWithResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedDeadLetterWithResourceIdentity.identity = EventSubscriptionIdentity.fromJson(reader);
                } else if ("deadLetterDestination".equals(fieldName)) {
                    deserializedDeadLetterWithResourceIdentity.deadLetterDestination
                        = DeadLetterDestination.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeadLetterWithResourceIdentity;
        });
    }
}
