// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the delivery configuration information of the event subscription.
 */
@Fluent
public final class DeliveryConfiguration implements JsonSerializable<DeliveryConfiguration> {
    /*
     * Delivery mode of the event subscription.
     */
    private DeliveryMode deliveryMode;

    /*
     * This property should be populated when deliveryMode is queue and represents information about the queue
     * subscription.
     */
    private QueueInfo queue;

    /*
     * This property should be populated when deliveryMode is push and represents information about the push
     * subscription.
     */
    private PushInfo push;

    /**
     * Creates an instance of DeliveryConfiguration class.
     */
    public DeliveryConfiguration() {
    }

    /**
     * Get the deliveryMode property: Delivery mode of the event subscription.
     * 
     * @return the deliveryMode value.
     */
    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    /**
     * Set the deliveryMode property: Delivery mode of the event subscription.
     * 
     * @param deliveryMode the deliveryMode value to set.
     * @return the DeliveryConfiguration object itself.
     */
    public DeliveryConfiguration withDeliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    /**
     * Get the queue property: This property should be populated when deliveryMode is queue and represents information
     * about the queue subscription.
     * 
     * @return the queue value.
     */
    public QueueInfo queue() {
        return this.queue;
    }

    /**
     * Set the queue property: This property should be populated when deliveryMode is queue and represents information
     * about the queue subscription.
     * 
     * @param queue the queue value to set.
     * @return the DeliveryConfiguration object itself.
     */
    public DeliveryConfiguration withQueue(QueueInfo queue) {
        this.queue = queue;
        return this;
    }

    /**
     * Get the push property: This property should be populated when deliveryMode is push and represents information
     * about the push subscription.
     * 
     * @return the push value.
     */
    public PushInfo push() {
        return this.push;
    }

    /**
     * Set the push property: This property should be populated when deliveryMode is push and represents information
     * about the push subscription.
     * 
     * @param push the push value to set.
     * @return the DeliveryConfiguration object itself.
     */
    public DeliveryConfiguration withPush(PushInfo push) {
        this.push = push;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (queue() != null) {
            queue().validate();
        }
        if (push() != null) {
            push().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deliveryMode", this.deliveryMode == null ? null : this.deliveryMode.toString());
        jsonWriter.writeJsonField("queue", this.queue);
        jsonWriter.writeJsonField("push", this.push);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeliveryConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeliveryConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeliveryConfiguration.
     */
    public static DeliveryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryConfiguration deserializedDeliveryConfiguration = new DeliveryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deliveryMode".equals(fieldName)) {
                    deserializedDeliveryConfiguration.deliveryMode = DeliveryMode.fromString(reader.getString());
                } else if ("queue".equals(fieldName)) {
                    deserializedDeliveryConfiguration.queue = QueueInfo.fromJson(reader);
                } else if ("push".equals(fieldName)) {
                    deserializedDeliveryConfiguration.push = PushInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeliveryConfiguration;
        });
    }
}
