// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The event delivery schema for the event subscription.
 */
public final class DeliverySchema extends ExpandableStringEnum<DeliverySchema> {
    /**
     * Static value CloudEventSchemaV1_0 for DeliverySchema.
     */
    public static final DeliverySchema CLOUD_EVENT_SCHEMA_V1_0 = fromString("CloudEventSchemaV1_0");

    /**
     * Creates a new instance of DeliverySchema value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DeliverySchema() {
    }

    /**
     * Creates or finds a DeliverySchema from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DeliverySchema.
     */
    public static DeliverySchema fromString(String name) {
        return fromString(name, DeliverySchema.class);
    }

    /**
     * Gets known DeliverySchema values.
     * 
     * @return known DeliverySchema values.
     */
    public static Collection<DeliverySchema> values() {
        return values(DeliverySchema.class);
    }
}
