// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the domain topic.
 */
public final class DomainTopicProvisioningState extends ExpandableStringEnum<DomainTopicProvisioningState> {
    /**
     * Static value Creating for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Succeeded for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for DomainTopicProvisioningState.
     */
    public static final DomainTopicProvisioningState FAILED = fromString("Failed");

    /**
     * Creates a new instance of DomainTopicProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DomainTopicProvisioningState() {
    }

    /**
     * Creates or finds a DomainTopicProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DomainTopicProvisioningState.
     */
    public static DomainTopicProvisioningState fromString(String name) {
        return fromString(name, DomainTopicProvisioningState.class);
    }

    /**
     * Gets known DomainTopicProvisioningState values.
     * 
     * @return known DomainTopicProvisioningState values.
     */
    public static Collection<DomainTopicProvisioningState> values() {
        return values(DomainTopicProvisioningState.class);
    }
}
