// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.DomainTopicInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Domain Topics operation.
 */
@Fluent
public final class DomainTopicsListResult implements JsonSerializable<DomainTopicsListResult> {
    /*
     * A collection of Domain Topics.
     */
    private List<DomainTopicInner> value;

    /*
     * A link for the next page of domain topics.
     */
    private String nextLink;

    /**
     * Creates an instance of DomainTopicsListResult class.
     */
    public DomainTopicsListResult() {
    }

    /**
     * Get the value property: A collection of Domain Topics.
     * 
     * @return the value value.
     */
    public List<DomainTopicInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Domain Topics.
     * 
     * @param value the value value to set.
     * @return the DomainTopicsListResult object itself.
     */
    public DomainTopicsListResult withValue(List<DomainTopicInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of domain topics.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of domain topics.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DomainTopicsListResult object itself.
     */
    public DomainTopicsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DomainTopicsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DomainTopicsListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DomainTopicsListResult.
     */
    public static DomainTopicsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainTopicsListResult deserializedDomainTopicsListResult = new DomainTopicsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DomainTopicInner> value = reader.readArray(reader1 -> DomainTopicInner.fromJson(reader1));
                    deserializedDomainTopicsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDomainTopicsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDomainTopicsListResult;
        });
    }
}
