// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This determines the format that is expected for incoming events published to the topic.
 */
public final class EventInputSchema extends ExpandableStringEnum<EventInputSchema> {
    /**
     * Static value CloudEventSchemaV1_0 for EventInputSchema.
     */
    public static final EventInputSchema CLOUD_EVENT_SCHEMA_V1_0 = fromString("CloudEventSchemaV1_0");

    /**
     * Creates a new instance of EventInputSchema value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EventInputSchema() {
    }

    /**
     * Creates or finds a EventInputSchema from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EventInputSchema.
     */
    public static EventInputSchema fromString(String name) {
        return fromString(name, EventInputSchema.class);
    }

    /**
     * Gets known EventInputSchema values.
     * 
     * @return known EventInputSchema values.
     */
    public static Collection<EventInputSchema> values() {
        return values(EventInputSchema.class);
    }
}
