// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Filter for the Event Subscription.
 */
@Fluent
public final class EventSubscriptionFilter implements JsonSerializable<EventSubscriptionFilter> {
    /*
     * An optional string to filter events for an event subscription based on a resource path prefix.
     * The format of this depends on the publisher of the events.
     * Wildcard characters are not supported in this path.
     */
    private String subjectBeginsWith;

    /*
     * An optional string to filter events for an event subscription based on a resource path suffix.
     * Wildcard characters are not supported in this path.
     */
    private String subjectEndsWith;

    /*
     * A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to
     * all default event types, set the IncludedEventTypes to null.
     */
    private List<String> includedEventTypes;

    /*
     * Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
     * should be compared in a case sensitive manner.
     */
    private Boolean isSubjectCaseSensitive;

    /*
     * Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
     */
    private Boolean enableAdvancedFilteringOnArrays;

    /*
     * An array of advanced filters that are used for filtering event subscriptions.
     */
    private List<AdvancedFilter> advancedFilters;

    /**
     * Creates an instance of EventSubscriptionFilter class.
     */
    public EventSubscriptionFilter() {
    }

    /**
     * Get the subjectBeginsWith property: An optional string to filter events for an event subscription based on a
     * resource path prefix.
     * The format of this depends on the publisher of the events.
     * Wildcard characters are not supported in this path.
     * 
     * @return the subjectBeginsWith value.
     */
    public String subjectBeginsWith() {
        return this.subjectBeginsWith;
    }

    /**
     * Set the subjectBeginsWith property: An optional string to filter events for an event subscription based on a
     * resource path prefix.
     * The format of this depends on the publisher of the events.
     * Wildcard characters are not supported in this path.
     * 
     * @param subjectBeginsWith the subjectBeginsWith value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withSubjectBeginsWith(String subjectBeginsWith) {
        this.subjectBeginsWith = subjectBeginsWith;
        return this;
    }

    /**
     * Get the subjectEndsWith property: An optional string to filter events for an event subscription based on a
     * resource path suffix.
     * Wildcard characters are not supported in this path.
     * 
     * @return the subjectEndsWith value.
     */
    public String subjectEndsWith() {
        return this.subjectEndsWith;
    }

    /**
     * Set the subjectEndsWith property: An optional string to filter events for an event subscription based on a
     * resource path suffix.
     * Wildcard characters are not supported in this path.
     * 
     * @param subjectEndsWith the subjectEndsWith value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withSubjectEndsWith(String subjectEndsWith) {
        this.subjectEndsWith = subjectEndsWith;
        return this;
    }

    /**
     * Get the includedEventTypes property: A list of applicable event types that need to be part of the event
     * subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     * 
     * @return the includedEventTypes value.
     */
    public List<String> includedEventTypes() {
        return this.includedEventTypes;
    }

    /**
     * Set the includedEventTypes property: A list of applicable event types that need to be part of the event
     * subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     * 
     * @param includedEventTypes the includedEventTypes value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withIncludedEventTypes(List<String> includedEventTypes) {
        this.includedEventTypes = includedEventTypes;
        return this;
    }

    /**
     * Get the isSubjectCaseSensitive property: Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the
     * filter
     * should be compared in a case sensitive manner.
     * 
     * @return the isSubjectCaseSensitive value.
     */
    public Boolean isSubjectCaseSensitive() {
        return this.isSubjectCaseSensitive;
    }

    /**
     * Set the isSubjectCaseSensitive property: Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the
     * filter
     * should be compared in a case sensitive manner.
     * 
     * @param isSubjectCaseSensitive the isSubjectCaseSensitive value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withIsSubjectCaseSensitive(Boolean isSubjectCaseSensitive) {
        this.isSubjectCaseSensitive = isSubjectCaseSensitive;
        return this;
    }

    /**
     * Get the enableAdvancedFilteringOnArrays property: Allows advanced filters to be evaluated against an array of
     * values instead of expecting a singular value.
     * 
     * @return the enableAdvancedFilteringOnArrays value.
     */
    public Boolean enableAdvancedFilteringOnArrays() {
        return this.enableAdvancedFilteringOnArrays;
    }

    /**
     * Set the enableAdvancedFilteringOnArrays property: Allows advanced filters to be evaluated against an array of
     * values instead of expecting a singular value.
     * 
     * @param enableAdvancedFilteringOnArrays the enableAdvancedFilteringOnArrays value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withEnableAdvancedFilteringOnArrays(Boolean enableAdvancedFilteringOnArrays) {
        this.enableAdvancedFilteringOnArrays = enableAdvancedFilteringOnArrays;
        return this;
    }

    /**
     * Get the advancedFilters property: An array of advanced filters that are used for filtering event subscriptions.
     * 
     * @return the advancedFilters value.
     */
    public List<AdvancedFilter> advancedFilters() {
        return this.advancedFilters;
    }

    /**
     * Set the advancedFilters property: An array of advanced filters that are used for filtering event subscriptions.
     * 
     * @param advancedFilters the advancedFilters value to set.
     * @return the EventSubscriptionFilter object itself.
     */
    public EventSubscriptionFilter withAdvancedFilters(List<AdvancedFilter> advancedFilters) {
        this.advancedFilters = advancedFilters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (advancedFilters() != null) {
            advancedFilters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subjectBeginsWith", this.subjectBeginsWith);
        jsonWriter.writeStringField("subjectEndsWith", this.subjectEndsWith);
        jsonWriter.writeArrayField("includedEventTypes", this.includedEventTypes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isSubjectCaseSensitive", this.isSubjectCaseSensitive);
        jsonWriter.writeBooleanField("enableAdvancedFilteringOnArrays", this.enableAdvancedFilteringOnArrays);
        jsonWriter.writeArrayField("advancedFilters", this.advancedFilters,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventSubscriptionFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventSubscriptionFilter if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventSubscriptionFilter.
     */
    public static EventSubscriptionFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventSubscriptionFilter deserializedEventSubscriptionFilter = new EventSubscriptionFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subjectBeginsWith".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.subjectBeginsWith = reader.getString();
                } else if ("subjectEndsWith".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.subjectEndsWith = reader.getString();
                } else if ("includedEventTypes".equals(fieldName)) {
                    List<String> includedEventTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedEventSubscriptionFilter.includedEventTypes = includedEventTypes;
                } else if ("isSubjectCaseSensitive".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.isSubjectCaseSensitive
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableAdvancedFilteringOnArrays".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.enableAdvancedFilteringOnArrays
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("advancedFilters".equals(fieldName)) {
                    List<AdvancedFilter> advancedFilters
                        = reader.readArray(reader1 -> AdvancedFilter.fromJson(reader1));
                    deserializedEventSubscriptionFilter.advancedFilters = advancedFilters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventSubscriptionFilter;
        });
    }
}
