// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The identity information with the event subscription.
 */
@Fluent
public final class EventSubscriptionIdentity implements JsonSerializable<EventSubscriptionIdentity> {
    /*
     * The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
     */
    private EventSubscriptionIdentityType type;

    /*
     * The user identity associated with the resource.
     */
    private String userAssignedIdentity;

    /**
     * Creates an instance of EventSubscriptionIdentity class.
     */
    public EventSubscriptionIdentity() {
    }

    /**
     * Get the type property: The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
     * 
     * @return the type value.
     */
    public EventSubscriptionIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
     * 
     * @param type the type value to set.
     * @return the EventSubscriptionIdentity object itself.
     */
    public EventSubscriptionIdentity withType(EventSubscriptionIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentity property: The user identity associated with the resource.
     * 
     * @return the userAssignedIdentity value.
     */
    public String userAssignedIdentity() {
        return this.userAssignedIdentity;
    }

    /**
     * Set the userAssignedIdentity property: The user identity associated with the resource.
     * 
     * @param userAssignedIdentity the userAssignedIdentity value to set.
     * @return the EventSubscriptionIdentity object itself.
     */
    public EventSubscriptionIdentity withUserAssignedIdentity(String userAssignedIdentity) {
        this.userAssignedIdentity = userAssignedIdentity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("userAssignedIdentity", this.userAssignedIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventSubscriptionIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventSubscriptionIdentity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventSubscriptionIdentity.
     */
    public static EventSubscriptionIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventSubscriptionIdentity deserializedEventSubscriptionIdentity = new EventSubscriptionIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedEventSubscriptionIdentity.type
                        = EventSubscriptionIdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionIdentity.userAssignedIdentity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventSubscriptionIdentity;
        });
    }
}
