// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
 */
public final class EventSubscriptionIdentityType extends ExpandableStringEnum<EventSubscriptionIdentityType> {
    /**
     * Static value SystemAssigned for EventSubscriptionIdentityType.
     */
    public static final EventSubscriptionIdentityType SYSTEM_ASSIGNED = fromString("SystemAssigned");

    /**
     * Static value UserAssigned for EventSubscriptionIdentityType.
     */
    public static final EventSubscriptionIdentityType USER_ASSIGNED = fromString("UserAssigned");

    /**
     * Creates a new instance of EventSubscriptionIdentityType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EventSubscriptionIdentityType() {
    }

    /**
     * Creates or finds a EventSubscriptionIdentityType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EventSubscriptionIdentityType.
     */
    public static EventSubscriptionIdentityType fromString(String name) {
        return fromString(name, EventSubscriptionIdentityType.class);
    }

    /**
     * Gets known EventSubscriptionIdentityType values.
     * 
     * @return known EventSubscriptionIdentityType values.
     */
    public static Collection<EventSubscriptionIdentityType> values() {
        return values(EventSubscriptionIdentityType.class);
    }
}
