// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the event subscription.
 */
public final class EventSubscriptionProvisioningState extends ExpandableStringEnum<EventSubscriptionProvisioningState> {
    /**
     * Static value Creating for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Succeeded for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState FAILED = fromString("Failed");

    /**
     * Static value AwaitingManualAction for EventSubscriptionProvisioningState.
     */
    public static final EventSubscriptionProvisioningState AWAITING_MANUAL_ACTION = fromString("AwaitingManualAction");

    /**
     * Creates a new instance of EventSubscriptionProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EventSubscriptionProvisioningState() {
    }

    /**
     * Creates or finds a EventSubscriptionProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EventSubscriptionProvisioningState.
     */
    public static EventSubscriptionProvisioningState fromString(String name) {
        return fromString(name, EventSubscriptionProvisioningState.class);
    }

    /**
     * Gets known EventSubscriptionProvisioningState values.
     * 
     * @return known EventSubscriptionProvisioningState values.
     */
    public static Collection<EventSubscriptionProvisioningState> values() {
        return values(EventSubscriptionProvisioningState.class);
    }
}
