// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Event Types operation.
 */
@Fluent
public final class EventTypesListResult implements JsonSerializable<EventTypesListResult> {
    /*
     * A collection of event types
     */
    private List<EventTypeInner> value;

    /**
     * Creates an instance of EventTypesListResult class.
     */
    public EventTypesListResult() {
    }

    /**
     * Get the value property: A collection of event types.
     * 
     * @return the value value.
     */
    public List<EventTypeInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of event types.
     * 
     * @param value the value value to set.
     * @return the EventTypesListResult object itself.
     */
    public EventTypesListResult withValue(List<EventTypeInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventTypesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventTypesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventTypesListResult.
     */
    public static EventTypesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventTypesListResult deserializedEventTypesListResult = new EventTypesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EventTypeInner> value = reader.readArray(reader1 -> EventTypeInner.fromJson(reader1));
                    deserializedEventTypesListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventTypesListResult;
        });
    }
}
