// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 */
public final class FilterOperatorType extends ExpandableStringEnum<FilterOperatorType> {
    /**
     * Static value NumberIn for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_IN = fromString("NumberIn");

    /**
     * Static value NumberNotIn for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_NOT_IN = fromString("NumberNotIn");

    /**
     * Static value NumberLessThan for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_LESS_THAN = fromString("NumberLessThan");

    /**
     * Static value NumberGreaterThan for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_GREATER_THAN = fromString("NumberGreaterThan");

    /**
     * Static value NumberLessThanOrEquals for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_LESS_THAN_OR_EQUALS = fromString("NumberLessThanOrEquals");

    /**
     * Static value NumberGreaterThanOrEquals for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_GREATER_THAN_OR_EQUALS = fromString("NumberGreaterThanOrEquals");

    /**
     * Static value BoolEquals for FilterOperatorType.
     */
    public static final FilterOperatorType BOOL_EQUALS = fromString("BoolEquals");

    /**
     * Static value StringIn for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_IN = fromString("StringIn");

    /**
     * Static value StringNotIn for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_NOT_IN = fromString("StringNotIn");

    /**
     * Static value StringBeginsWith for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_BEGINS_WITH = fromString("StringBeginsWith");

    /**
     * Static value StringEndsWith for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_ENDS_WITH = fromString("StringEndsWith");

    /**
     * Static value StringContains for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_CONTAINS = fromString("StringContains");

    /**
     * Static value NumberInRange for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_IN_RANGE = fromString("NumberInRange");

    /**
     * Static value NumberNotInRange for FilterOperatorType.
     */
    public static final FilterOperatorType NUMBER_NOT_IN_RANGE = fromString("NumberNotInRange");

    /**
     * Static value StringNotBeginsWith for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_NOT_BEGINS_WITH = fromString("StringNotBeginsWith");

    /**
     * Static value StringNotEndsWith for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_NOT_ENDS_WITH = fromString("StringNotEndsWith");

    /**
     * Static value StringNotContains for FilterOperatorType.
     */
    public static final FilterOperatorType STRING_NOT_CONTAINS = fromString("StringNotContains");

    /**
     * Static value IsNullOrUndefined for FilterOperatorType.
     */
    public static final FilterOperatorType IS_NULL_OR_UNDEFINED = fromString("IsNullOrUndefined");

    /**
     * Static value IsNotNull for FilterOperatorType.
     */
    public static final FilterOperatorType IS_NOT_NULL = fromString("IsNotNull");

    /**
     * Creates a new instance of FilterOperatorType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FilterOperatorType() {
    }

    /**
     * Creates or finds a FilterOperatorType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding FilterOperatorType.
     */
    public static FilterOperatorType fromString(String name) {
        return fromString(name, FilterOperatorType.class);
    }

    /**
     * Gets known FilterOperatorType values.
     * 
     * @return known FilterOperatorType values.
     */
    public static Collection<FilterOperatorType> values() {
        return values(FilterOperatorType.class);
    }
}
