// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Filters configuration for the Event Subscription.
 */
@Fluent
public final class FiltersConfiguration implements JsonSerializable<FiltersConfiguration> {
    /*
     * A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to
     * all default event types, set the IncludedEventTypes to null.
     */
    private List<String> includedEventTypes;

    /*
     * An array of filters that are used for filtering event subscriptions.
     */
    private List<Filter> filters;

    /**
     * Creates an instance of FiltersConfiguration class.
     */
    public FiltersConfiguration() {
    }

    /**
     * Get the includedEventTypes property: A list of applicable event types that need to be part of the event
     * subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     * 
     * @return the includedEventTypes value.
     */
    public List<String> includedEventTypes() {
        return this.includedEventTypes;
    }

    /**
     * Set the includedEventTypes property: A list of applicable event types that need to be part of the event
     * subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     * 
     * @param includedEventTypes the includedEventTypes value to set.
     * @return the FiltersConfiguration object itself.
     */
    public FiltersConfiguration withIncludedEventTypes(List<String> includedEventTypes) {
        this.includedEventTypes = includedEventTypes;
        return this;
    }

    /**
     * Get the filters property: An array of filters that are used for filtering event subscriptions.
     * 
     * @return the filters value.
     */
    public List<Filter> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: An array of filters that are used for filtering event subscriptions.
     * 
     * @param filters the filters value to set.
     * @return the FiltersConfiguration object itself.
     */
    public FiltersConfiguration withFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (filters() != null) {
            filters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("includedEventTypes", this.includedEventTypes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FiltersConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FiltersConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FiltersConfiguration.
     */
    public static FiltersConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FiltersConfiguration deserializedFiltersConfiguration = new FiltersConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("includedEventTypes".equals(fieldName)) {
                    List<String> includedEventTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedFiltersConfiguration.includedEventTypes = includedEventTypes;
                } else if ("filters".equals(fieldName)) {
                    List<Filter> filters = reader.readArray(reader1 -> Filter.fromJson(reader1));
                    deserializedFiltersConfiguration.filters = filters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFiltersConfiguration;
        });
    }
}
