// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The InboundIpRule model.
 */
@Fluent
public final class InboundIpRule implements JsonSerializable<InboundIpRule> {
    /*
     * IP Address in CIDR notation e.g., 10.0.0.0/8.
     */
    private String ipMask;

    /*
     * Action to perform based on the match or no match of the IpMask.
     */
    private IpActionType action;

    /**
     * Creates an instance of InboundIpRule class.
     */
    public InboundIpRule() {
    }

    /**
     * Get the ipMask property: IP Address in CIDR notation e.g., 10.0.0.0/8.
     * 
     * @return the ipMask value.
     */
    public String ipMask() {
        return this.ipMask;
    }

    /**
     * Set the ipMask property: IP Address in CIDR notation e.g., 10.0.0.0/8.
     * 
     * @param ipMask the ipMask value to set.
     * @return the InboundIpRule object itself.
     */
    public InboundIpRule withIpMask(String ipMask) {
        this.ipMask = ipMask;
        return this;
    }

    /**
     * Get the action property: Action to perform based on the match or no match of the IpMask.
     * 
     * @return the action value.
     */
    public IpActionType action() {
        return this.action;
    }

    /**
     * Set the action property: Action to perform based on the match or no match of the IpMask.
     * 
     * @param action the action value to set.
     * @return the InboundIpRule object itself.
     */
    public InboundIpRule withAction(IpActionType action) {
        this.action = action;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipMask", this.ipMask);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InboundIpRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InboundIpRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the InboundIpRule.
     */
    public static InboundIpRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InboundIpRule deserializedInboundIpRule = new InboundIpRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipMask".equals(fieldName)) {
                    deserializedInboundIpRule.ipMask = reader.getString();
                } else if ("action".equals(fieldName)) {
                    deserializedInboundIpRule.action = IpActionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInboundIpRule;
        });
    }
}
