// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Additional information about every inline event.
 */
@Fluent
public final class InlineEventProperties implements JsonSerializable<InlineEventProperties> {
    /*
     * The description for the inline event.
     */
    private String description;

    /*
     * The displayName for the inline event.
     */
    private String displayName;

    /*
     * The documentationUrl for the inline event.
     */
    private String documentationUrl;

    /*
     * The dataSchemaUrl for the inline event.
     */
    private String dataSchemaUrl;

    /**
     * Creates an instance of InlineEventProperties class.
     */
    public InlineEventProperties() {
    }

    /**
     * Get the description property: The description for the inline event.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description for the inline event.
     * 
     * @param description the description value to set.
     * @return the InlineEventProperties object itself.
     */
    public InlineEventProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The displayName for the inline event.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The displayName for the inline event.
     * 
     * @param displayName the displayName value to set.
     * @return the InlineEventProperties object itself.
     */
    public InlineEventProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the documentationUrl property: The documentationUrl for the inline event.
     * 
     * @return the documentationUrl value.
     */
    public String documentationUrl() {
        return this.documentationUrl;
    }

    /**
     * Set the documentationUrl property: The documentationUrl for the inline event.
     * 
     * @param documentationUrl the documentationUrl value to set.
     * @return the InlineEventProperties object itself.
     */
    public InlineEventProperties withDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
        return this;
    }

    /**
     * Get the dataSchemaUrl property: The dataSchemaUrl for the inline event.
     * 
     * @return the dataSchemaUrl value.
     */
    public String dataSchemaUrl() {
        return this.dataSchemaUrl;
    }

    /**
     * Set the dataSchemaUrl property: The dataSchemaUrl for the inline event.
     * 
     * @param dataSchemaUrl the dataSchemaUrl value to set.
     * @return the InlineEventProperties object itself.
     */
    public InlineEventProperties withDataSchemaUrl(String dataSchemaUrl) {
        this.dataSchemaUrl = dataSchemaUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("documentationUrl", this.documentationUrl);
        jsonWriter.writeStringField("dataSchemaUrl", this.dataSchemaUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InlineEventProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InlineEventProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InlineEventProperties.
     */
    public static InlineEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InlineEventProperties deserializedInlineEventProperties = new InlineEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedInlineEventProperties.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedInlineEventProperties.displayName = reader.getString();
                } else if ("documentationUrl".equals(fieldName)) {
                    deserializedInlineEventProperties.documentationUrl = reader.getString();
                } else if ("dataSchemaUrl".equals(fieldName)) {
                    deserializedInlineEventProperties.dataSchemaUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInlineEventProperties;
        });
    }
}
