// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is used to express the source of an input schema mapping for a single target field in the Event Grid Event
 * schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a
 * field in the input event schema.
 */
@Fluent
public final class JsonField implements JsonSerializable<JsonField> {
    /*
     * Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    private String sourceField;

    /**
     * Creates an instance of JsonField class.
     */
    public JsonField() {
    }

    /**
     * Get the sourceField property: Name of a field in the input event schema that's to be used as the source of a
     * mapping.
     * 
     * @return the sourceField value.
     */
    public String sourceField() {
        return this.sourceField;
    }

    /**
     * Set the sourceField property: Name of a field in the input event schema that's to be used as the source of a
     * mapping.
     * 
     * @param sourceField the sourceField value to set.
     * @return the JsonField object itself.
     */
    public JsonField withSourceField(String sourceField) {
        this.sourceField = sourceField;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceField", this.sourceField);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JsonField from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JsonField if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the JsonField.
     */
    public static JsonField fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonField deserializedJsonField = new JsonField();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceField".equals(fieldName)) {
                    deserializedJsonField.sourceField = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJsonField;
        });
    }
}
