// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is used to express the source of an input schema mapping for a single target field
 * in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
 * 'eventtype' and 'dataversion' properties. This represents a field in the input event schema
 * along with a default value to be used, and at least one of these two properties should be provided.
 */
@Fluent
public final class JsonFieldWithDefault implements JsonSerializable<JsonFieldWithDefault> {
    /*
     * Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    private String sourceField;

    /*
     * The default value to be used for mapping when a SourceField is not provided or if there's no property with the
     * specified name in the published JSON event payload.
     */
    private String defaultValue;

    /**
     * Creates an instance of JsonFieldWithDefault class.
     */
    public JsonFieldWithDefault() {
    }

    /**
     * Get the sourceField property: Name of a field in the input event schema that's to be used as the source of a
     * mapping.
     * 
     * @return the sourceField value.
     */
    public String sourceField() {
        return this.sourceField;
    }

    /**
     * Set the sourceField property: Name of a field in the input event schema that's to be used as the source of a
     * mapping.
     * 
     * @param sourceField the sourceField value to set.
     * @return the JsonFieldWithDefault object itself.
     */
    public JsonFieldWithDefault withSourceField(String sourceField) {
        this.sourceField = sourceField;
        return this;
    }

    /**
     * Get the defaultValue property: The default value to be used for mapping when a SourceField is not provided or if
     * there's no property with the specified name in the published JSON event payload.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: The default value to be used for mapping when a SourceField is not provided or if
     * there's no property with the specified name in the published JSON event payload.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the JsonFieldWithDefault object itself.
     */
    public JsonFieldWithDefault withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceField", this.sourceField);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JsonFieldWithDefault from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JsonFieldWithDefault if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JsonFieldWithDefault.
     */
    public static JsonFieldWithDefault fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonFieldWithDefault deserializedJsonFieldWithDefault = new JsonFieldWithDefault();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceField".equals(fieldName)) {
                    deserializedJsonFieldWithDefault.sourceField = reader.getString();
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedJsonFieldWithDefault.defaultValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJsonFieldWithDefault;
        });
    }
}
