// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.MonitorAlertEventSubscriptionDestinationProperties;
import java.io.IOException;
import java.util.List;

/**
 * Information about the Monitor Alert destination for an event subscription.
 */
@Fluent
public final class MonitorAlertEventSubscriptionDestination extends EventSubscriptionDestination {
    /*
     * Type of the endpoint for the event subscription destination.
     */
    private EndpointType endpointType = EndpointType.MONITOR_ALERT;

    /*
     * Monitor Alert properties of the event subscription destination.
     */
    private MonitorAlertEventSubscriptionDestinationProperties innerProperties;

    /**
     * Creates an instance of MonitorAlertEventSubscriptionDestination class.
     */
    public MonitorAlertEventSubscriptionDestination() {
    }

    /**
     * Get the endpointType property: Type of the endpoint for the event subscription destination.
     * 
     * @return the endpointType value.
     */
    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    /**
     * Get the innerProperties property: Monitor Alert properties of the event subscription destination.
     * 
     * @return the innerProperties value.
     */
    MonitorAlertEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the severity property: The severity that will be attached to every Alert fired through this event
     * subscription.
     * This field must be provided.
     * 
     * @return the severity value.
     */
    public MonitorAlertSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    /**
     * Set the severity property: The severity that will be attached to every Alert fired through this event
     * subscription.
     * This field must be provided.
     * 
     * @param severity the severity value to set.
     * @return the MonitorAlertEventSubscriptionDestination object itself.
     */
    public MonitorAlertEventSubscriptionDestination withSeverity(MonitorAlertSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    /**
     * Get the description property: The description that will be attached to every Alert fired through this event
     * subscription.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description that will be attached to every Alert fired through this event
     * subscription.
     * 
     * @param description the description value to set.
     * @return the MonitorAlertEventSubscriptionDestination object itself.
     */
    public MonitorAlertEventSubscriptionDestination withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the actionGroups property: The list of ARM Ids of Action Groups that will be triggered on every Alert fired
     * through this event subscription.
     * Each resource ARM Id should follow this pattern:
     * /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.
     * 
     * @return the actionGroups value.
     */
    public List<String> actionGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().actionGroups();
    }

    /**
     * Set the actionGroups property: The list of ARM Ids of Action Groups that will be triggered on every Alert fired
     * through this event subscription.
     * Each resource ARM Id should follow this pattern:
     * /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.
     * 
     * @param actionGroups the actionGroups value to set.
     * @return the MonitorAlertEventSubscriptionDestination object itself.
     */
    public MonitorAlertEventSubscriptionDestination withActionGroups(List<String> actionGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withActionGroups(actionGroups);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MonitorAlertEventSubscriptionDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MonitorAlertEventSubscriptionDestination if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MonitorAlertEventSubscriptionDestination.
     */
    public static MonitorAlertEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MonitorAlertEventSubscriptionDestination deserializedMonitorAlertEventSubscriptionDestination
                = new MonitorAlertEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpointType".equals(fieldName)) {
                    deserializedMonitorAlertEventSubscriptionDestination.endpointType
                        = EndpointType.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedMonitorAlertEventSubscriptionDestination.innerProperties
                        = MonitorAlertEventSubscriptionDestinationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMonitorAlertEventSubscriptionDestination;
        });
    }
}
