// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of Namespace.
 */
public interface Namespace {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the sku property: Represents available Sku pricing tiers.
     * 
     * @return the sku value.
     */
    NamespaceSku sku();

    /**
     * Gets the identity property: Identity information for the Namespace resource.
     * 
     * @return the identity value.
     */
    IdentityInfo identity();

    /**
     * Gets the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the privateEndpointConnections property: List of private endpoint connections.
     * 
     * @return the privateEndpointConnections value.
     */
    List<PrivateEndpointConnection> privateEndpointConnections();

    /**
     * Gets the provisioningState property: Provisioning state of the namespace resource.
     * 
     * @return the provisioningState value.
     */
    NamespaceProvisioningState provisioningState();

    /**
     * Gets the topicsConfiguration property: Topics configuration information for the namespace resource.
     * 
     * @return the topicsConfiguration value.
     */
    TopicsConfiguration topicsConfiguration();

    /**
     * Gets the topicSpacesConfiguration property: Topic spaces configuration information for the namespace resource.
     * 
     * @return the topicSpacesConfiguration value.
     */
    TopicSpacesConfiguration topicSpacesConfiguration();

    /**
     * Gets the isZoneRedundant property: This is an optional property and it allows the user to specify if the
     * namespace resource supports zone-redundancy capability or not. If this
     * property is not specified explicitly by the user, its default value depends on the following conditions:
     * a. For Availability Zones enabled regions - The default property value would be true.
     * b. For non-Availability Zones enabled regions - The default property value would be false.
     * Once specified, this property cannot be updated.
     * 
     * @return the isZoneRedundant value.
     */
    Boolean isZoneRedundant();

    /**
     * Gets the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it
     * is enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
     * /&gt;.
     * 
     * @return the publicNetworkAccess value.
     */
    PublicNetworkAccess publicNetworkAccess();

    /**
     * Gets the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs.
     * Note: These are considered only if PublicNetworkAccess is enabled.
     * 
     * @return the inboundIpRules value.
     */
    List<InboundIpRule> inboundIpRules();

    /**
     * Gets the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish to this
     * namespace. Only TLS version 1.2 is supported.
     * 
     * @return the minimumTlsVersionAllowed value.
     */
    TlsVersion minimumTlsVersionAllowed();

    /**
     * Gets the region of the resource.
     * 
     * @return the region of the resource.
     */
    Region region();

    /**
     * Gets the name of the resource region.
     * 
     * @return the name of the resource region.
     */
    String regionName();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner object.
     * 
     * @return the inner object.
     */
    NamespaceInner innerModel();

    /**
     * The entirety of the Namespace definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithLocation,
        DefinitionStages.WithResourceGroup, DefinitionStages.WithCreate {
    }

    /**
     * The Namespace definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the Namespace definition.
         */
        interface Blank extends WithLocation {
        }

        /**
         * The stage of the Namespace definition allowing to specify location.
         */
        interface WithLocation {
            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(Region location);

            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(String location);
        }

        /**
         * The stage of the Namespace definition allowing to specify parent resource.
         */
        interface WithResourceGroup {
            /**
             * Specifies resourceGroupName.
             * 
             * @param resourceGroupName The name of the resource group within the user's subscription.
             * @return the next definition stage.
             */
            WithCreate withExistingResourceGroup(String resourceGroupName);
        }

        /**
         * The stage of the Namespace definition which contains all the minimum required properties for the resource to
         * be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithTags, DefinitionStages.WithSku, DefinitionStages.WithIdentity,
            DefinitionStages.WithPrivateEndpointConnections, DefinitionStages.WithTopicsConfiguration,
            DefinitionStages.WithTopicSpacesConfiguration, DefinitionStages.WithIsZoneRedundant,
            DefinitionStages.WithPublicNetworkAccess, DefinitionStages.WithInboundIpRules,
            DefinitionStages.WithMinimumTlsVersionAllowed {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            Namespace create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            Namespace create(Context context);
        }

        /**
         * The stage of the Namespace definition allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             * 
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            WithCreate withTags(Map<String, String> tags);
        }

        /**
         * The stage of the Namespace definition allowing to specify sku.
         */
        interface WithSku {
            /**
             * Specifies the sku property: Represents available Sku pricing tiers..
             * 
             * @param sku Represents available Sku pricing tiers.
             * @return the next definition stage.
             */
            WithCreate withSku(NamespaceSku sku);
        }

        /**
         * The stage of the Namespace definition allowing to specify identity.
         */
        interface WithIdentity {
            /**
             * Specifies the identity property: Identity information for the Namespace resource..
             * 
             * @param identity Identity information for the Namespace resource.
             * @return the next definition stage.
             */
            WithCreate withIdentity(IdentityInfo identity);
        }

        /**
         * The stage of the Namespace definition allowing to specify privateEndpointConnections.
         */
        interface WithPrivateEndpointConnections {
            /**
             * Specifies the privateEndpointConnections property: List of private endpoint connections..
             * 
             * @param privateEndpointConnections List of private endpoint connections.
             * @return the next definition stage.
             */
            WithCreate withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections);
        }

        /**
         * The stage of the Namespace definition allowing to specify topicsConfiguration.
         */
        interface WithTopicsConfiguration {
            /**
             * Specifies the topicsConfiguration property: Topics configuration information for the namespace resource.
             * 
             * @param topicsConfiguration Topics configuration information for the namespace resource.
             * @return the next definition stage.
             */
            WithCreate withTopicsConfiguration(TopicsConfiguration topicsConfiguration);
        }

        /**
         * The stage of the Namespace definition allowing to specify topicSpacesConfiguration.
         */
        interface WithTopicSpacesConfiguration {
            /**
             * Specifies the topicSpacesConfiguration property: Topic spaces configuration information for the namespace
             * resource.
             * 
             * @param topicSpacesConfiguration Topic spaces configuration information for the namespace resource.
             * @return the next definition stage.
             */
            WithCreate withTopicSpacesConfiguration(TopicSpacesConfiguration topicSpacesConfiguration);
        }

        /**
         * The stage of the Namespace definition allowing to specify isZoneRedundant.
         */
        interface WithIsZoneRedundant {
            /**
             * Specifies the isZoneRedundant property: This is an optional property and it allows the user to specify if
             * the namespace resource supports zone-redundancy capability or not. If this
             * property is not specified explicitly by the user, its default value depends on the following conditions:
             * a. For Availability Zones enabled regions - The default property value would be true.
             * b. For non-Availability Zones enabled regions - The default property value would be false.
             * Once specified, this property cannot be updated..
             * 
             * @param isZoneRedundant This is an optional property and it allows the user to specify if the namespace
             * resource supports zone-redundancy capability or not. If this
             * property is not specified explicitly by the user, its default value depends on the following conditions:
             * a. For Availability Zones enabled regions - The default property value would be true.
             * b. For non-Availability Zones enabled regions - The default property value would be false.
             * Once specified, this property cannot be updated.
             * @return the next definition stage.
             */
            WithCreate withIsZoneRedundant(Boolean isZoneRedundant);
        }

        /**
         * The stage of the Namespace definition allowing to specify publicNetworkAccess.
         */
        interface WithPublicNetworkAccess {
            /**
             * Specifies the publicNetworkAccess property: This determines if traffic is allowed over public network. By
             * default it is enabled.
             * You can further restrict to specific IPs by configuring &lt;seealso
             * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
             * /&gt;.
             * 
             * @param publicNetworkAccess This determines if traffic is allowed over public network. By default it is
             * enabled.
             * You can further restrict to specific IPs by configuring &lt;seealso
             * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
             * /&gt;.
             * @return the next definition stage.
             */
            WithCreate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess);
        }

        /**
         * The stage of the Namespace definition allowing to specify inboundIpRules.
         */
        interface WithInboundIpRules {
            /**
             * Specifies the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of
             * all IPs. Note: These are considered only if PublicNetworkAccess is enabled..
             * 
             * @param inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note:
             * These are considered only if PublicNetworkAccess is enabled.
             * @return the next definition stage.
             */
            WithCreate withInboundIpRules(List<InboundIpRule> inboundIpRules);
        }

        /**
         * The stage of the Namespace definition allowing to specify minimumTlsVersionAllowed.
         */
        interface WithMinimumTlsVersionAllowed {
            /**
             * Specifies the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish
             * to this namespace. Only TLS version 1.2 is supported..
             * 
             * @param minimumTlsVersionAllowed Minimum TLS version of the publisher allowed to publish to this
             * namespace. Only TLS version 1.2 is supported.
             * @return the next definition stage.
             */
            WithCreate withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed);
        }
    }

    /**
     * Begins update for the Namespace resource.
     * 
     * @return the stage of resource update.
     */
    Namespace.Update update();

    /**
     * The template for Namespace update.
     */
    interface Update extends UpdateStages.WithTags, UpdateStages.WithIdentity, UpdateStages.WithSku,
        UpdateStages.WithTopicSpacesConfiguration, UpdateStages.WithTopicsConfiguration,
        UpdateStages.WithPublicNetworkAccess, UpdateStages.WithInboundIpRules {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        Namespace apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        Namespace apply(Context context);
    }

    /**
     * The Namespace update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the Namespace update allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Tags of the namespace resource..
             * 
             * @param tags Tags of the namespace resource.
             * @return the next definition stage.
             */
            Update withTags(Map<String, String> tags);
        }

        /**
         * The stage of the Namespace update allowing to specify identity.
         */
        interface WithIdentity {
            /**
             * Specifies the identity property: Namespace resource identity information..
             * 
             * @param identity Namespace resource identity information.
             * @return the next definition stage.
             */
            Update withIdentity(IdentityInfo identity);
        }

        /**
         * The stage of the Namespace update allowing to specify sku.
         */
        interface WithSku {
            /**
             * Specifies the sku property: Represents available Sku pricing tiers..
             * 
             * @param sku Represents available Sku pricing tiers.
             * @return the next definition stage.
             */
            Update withSku(NamespaceSku sku);
        }

        /**
         * The stage of the Namespace update allowing to specify topicSpacesConfiguration.
         */
        interface WithTopicSpacesConfiguration {
            /**
             * Specifies the topicSpacesConfiguration property: Topic spaces configuration properties that can be
             * updated..
             * 
             * @param topicSpacesConfiguration Topic spaces configuration properties that can be updated.
             * @return the next definition stage.
             */
            Update withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration);
        }

        /**
         * The stage of the Namespace update allowing to specify topicsConfiguration.
         */
        interface WithTopicsConfiguration {
            /**
             * Specifies the topicsConfiguration property: Topics configuration properties that can be updated..
             * 
             * @param topicsConfiguration Topics configuration properties that can be updated.
             * @return the next definition stage.
             */
            Update withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration);
        }

        /**
         * The stage of the Namespace update allowing to specify publicNetworkAccess.
         */
        interface WithPublicNetworkAccess {
            /**
             * Specifies the publicNetworkAccess property: This determines if traffic is allowed over public network. By
             * default it is enabled.
             * You can further restrict to specific IPs by configuring &lt;seealso
             * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
             * /&gt;.
             * 
             * @param publicNetworkAccess This determines if traffic is allowed over public network. By default it is
             * enabled.
             * You can further restrict to specific IPs by configuring &lt;seealso
             * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
             * /&gt;.
             * @return the next definition stage.
             */
            Update withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess);
        }

        /**
         * The stage of the Namespace update allowing to specify inboundIpRules.
         */
        interface WithInboundIpRules {
            /**
             * Specifies the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of
             * all IPs. Note: These are considered only if PublicNetworkAccess is enabled..
             * 
             * @param inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note:
             * These are considered only if PublicNetworkAccess is enabled.
             * @return the next definition stage.
             */
            Update withInboundIpRules(List<InboundIpRule> inboundIpRules);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    Namespace refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    Namespace refresh(Context context);

    /**
     * List keys for a namespace.
     * 
     * List the two keys used to publish to a namespace.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace along with {@link Response}.
     */
    Response<NamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(Context context);

    /**
     * List keys for a namespace.
     * 
     * List the two keys used to publish to a namespace.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys listSharedAccessKeys();

    /**
     * Regenerate key for a namespace.
     * 
     * Regenerate a shared access key for a namespace.
     * 
     * @param regenerateKeyRequest Request body to regenerate key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest regenerateKeyRequest);

    /**
     * Regenerate key for a namespace.
     * 
     * Regenerate a shared access key for a namespace.
     * 
     * @param regenerateKeyRequest Request body to regenerate key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context);

    /**
     * Validate ownership for all custom domains in a namespace.
     * 
     * Performs ownership validation via checking TXT records for all custom domains in a namespace.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace custom domain ownership validation result.
     */
    CustomDomainOwnershipValidationResult validateCustomDomainOwnership();

    /**
     * Validate ownership for all custom domains in a namespace.
     * 
     * Performs ownership validation via checking TXT records for all custom domains in a namespace.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace custom domain ownership validation result.
     */
    CustomDomainOwnershipValidationResult validateCustomDomainOwnership(Context context);
}
