// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicUpdateParameterProperties;
import java.io.IOException;

/**
 * Properties of the namespace topic update.
 */
@Fluent
public final class NamespaceTopicUpdateParameters implements JsonSerializable<NamespaceTopicUpdateParameters> {
    /*
     * Properties of the namespace topic resource.
     */
    private NamespaceTopicUpdateParameterProperties innerProperties;

    /**
     * Creates an instance of NamespaceTopicUpdateParameters class.
     */
    public NamespaceTopicUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties of the namespace topic resource.
     * 
     * @return the innerProperties value.
     */
    private NamespaceTopicUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @return the eventRetentionInDays value.
     */
    public Integer eventRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().eventRetentionInDays();
    }

    /**
     * Set the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @param eventRetentionInDays the eventRetentionInDays value to set.
     * @return the NamespaceTopicUpdateParameters object itself.
     */
    public NamespaceTopicUpdateParameters withEventRetentionInDays(Integer eventRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicUpdateParameterProperties();
        }
        this.innerProperties().withEventRetentionInDays(eventRetentionInDays);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceTopicUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceTopicUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceTopicUpdateParameters.
     */
    public static NamespaceTopicUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceTopicUpdateParameters deserializedNamespaceTopicUpdateParameters
                = new NamespaceTopicUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedNamespaceTopicUpdateParameters.innerProperties
                        = NamespaceTopicUpdateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceTopicUpdateParameters;
        });
    }
}
