// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceUpdateParameterProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Properties to update namespace.
 */
@Fluent
public final class NamespaceUpdateParameters implements JsonSerializable<NamespaceUpdateParameters> {
    /*
     * Tags of the namespace resource.
     */
    private Map<String, String> tags;

    /*
     * Namespace resource identity information.
     */
    private IdentityInfo identity;

    /*
     * Represents available Sku pricing tiers.
     */
    private NamespaceSku sku;

    /*
     * Properties of the namespace resource.
     */
    private NamespaceUpdateParameterProperties innerProperties;

    /**
     * Creates an instance of NamespaceUpdateParameters class.
     */
    public NamespaceUpdateParameters() {
    }

    /**
     * Get the tags property: Tags of the namespace resource.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags of the namespace resource.
     * 
     * @param tags the tags value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: Namespace resource identity information.
     * 
     * @return the identity value.
     */
    public IdentityInfo identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Namespace resource identity information.
     * 
     * @param identity the identity value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the sku property: Represents available Sku pricing tiers.
     * 
     * @return the sku value.
     */
    public NamespaceSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Represents available Sku pricing tiers.
     * 
     * @param sku the sku value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withSku(NamespaceSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the namespace resource.
     * 
     * @return the innerProperties value.
     */
    private NamespaceUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the topicSpacesConfiguration property: Topic spaces configuration properties that can be updated.
     * 
     * @return the topicSpacesConfiguration value.
     */
    public UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().topicSpacesConfiguration();
    }

    /**
     * Set the topicSpacesConfiguration property: Topic spaces configuration properties that can be updated.
     * 
     * @param topicSpacesConfiguration the topicSpacesConfiguration value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters
        withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withTopicSpacesConfiguration(topicSpacesConfiguration);
        return this;
    }

    /**
     * Get the topicsConfiguration property: Topics configuration properties that can be updated.
     * 
     * @return the topicsConfiguration value.
     */
    public UpdateTopicsConfigurationInfo topicsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().topicsConfiguration();
    }

    /**
     * Set the topicsConfiguration property: Topics configuration properties that can be updated.
     * 
     * @param topicsConfiguration the topicsConfiguration value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withTopicsConfiguration(topicsConfiguration);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @return the inboundIpRules value.
     */
    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    /**
     * Set the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @param inboundIpRules the inboundIpRules value to set.
     * @return the NamespaceUpdateParameters object itself.
     */
    public NamespaceUpdateParameters withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceUpdateParameters.
     */
    public static NamespaceUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceUpdateParameters deserializedNamespaceUpdateParameters = new NamespaceUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNamespaceUpdateParameters.tags = tags;
                } else if ("identity".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.identity = IdentityInfo.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.sku = NamespaceSku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.innerProperties
                        = NamespaceUpdateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceUpdateParameters;
        });
    }
}
