// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of Namespaces.
 */
public interface Namespaces {
    /**
     * Get a namespace.
     * 
     * Get properties of a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a namespace along with {@link Response}.
     */
    Response<Namespace> getByResourceGroupWithResponse(String resourceGroupName, String namespaceName, Context context);

    /**
     * Get a namespace.
     * 
     * Get properties of a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a namespace.
     */
    Namespace getByResourceGroup(String resourceGroupName, String namespaceName);

    /**
     * Delete a namespace.
     * 
     * Delete existing namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByResourceGroup(String resourceGroupName, String namespaceName);

    /**
     * Delete a namespace.
     * 
     * Delete existing namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String namespaceName, Context context);

    /**
     * List namespaces under an Azure subscription.
     * 
     * List all the namespaces under an Azure subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Namespaces operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Namespace> list();

    /**
     * List namespaces under an Azure subscription.
     * 
     * List all the namespaces under an Azure subscription.
     * 
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Namespaces operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Namespace> list(String filter, Integer top, Context context);

    /**
     * List namespaces under a resource group.
     * 
     * List all the namespaces under a resource group.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Namespaces operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Namespace> listByResourceGroup(String resourceGroupName);

    /**
     * List namespaces under a resource group.
     * 
     * List all the namespaces under a resource group.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Namespaces operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Namespace> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context);

    /**
     * List keys for a namespace.
     * 
     * List the two keys used to publish to a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace along with {@link Response}.
     */
    Response<NamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(String resourceGroupName, String namespaceName,
        Context context);

    /**
     * List keys for a namespace.
     * 
     * List the two keys used to publish to a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys listSharedAccessKeys(String resourceGroupName, String namespaceName);

    /**
     * Regenerate key for a namespace.
     * 
     * Regenerate a shared access key for a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the Namespace.
     * @param regenerateKeyRequest Request body to regenerate key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys regenerateKey(String resourceGroupName, String namespaceName,
        NamespaceRegenerateKeyRequest regenerateKeyRequest);

    /**
     * Regenerate key for a namespace.
     * 
     * Regenerate a shared access key for a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the Namespace.
     * @param regenerateKeyRequest Request body to regenerate key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shared access keys of the Namespace.
     */
    NamespaceSharedAccessKeys regenerateKey(String resourceGroupName, String namespaceName,
        NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context);

    /**
     * Validate ownership for all custom domains in a namespace.
     * 
     * Performs ownership validation via checking TXT records for all custom domains in a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the Namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace custom domain ownership validation result.
     */
    CustomDomainOwnershipValidationResult validateCustomDomainOwnership(String resourceGroupName, String namespaceName);

    /**
     * Validate ownership for all custom domains in a namespace.
     * 
     * Performs ownership validation via checking TXT records for all custom domains in a namespace.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the Namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace custom domain ownership validation result.
     */
    CustomDomainOwnershipValidationResult validateCustomDomainOwnership(String resourceGroupName, String namespaceName,
        Context context);

    /**
     * Get a namespace.
     * 
     * Get properties of a namespace.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a namespace along with {@link Response}.
     */
    Namespace getById(String id);

    /**
     * Get a namespace.
     * 
     * Get properties of a namespace.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a namespace along with {@link Response}.
     */
    Response<Namespace> getByIdWithResponse(String id, Context context);

    /**
     * Delete a namespace.
     * 
     * Delete existing namespace.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete a namespace.
     * 
     * Delete existing namespace.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new Namespace resource.
     * 
     * @param name resource name.
     * @return the first stage of the new Namespace definition.
     */
    Namespace.DefinitionStages.Blank define(String name);
}
