// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Namespaces operation.
 */
@Fluent
public final class NamespacesListResult implements JsonSerializable<NamespacesListResult> {
    /*
     * A collection of namespaces.
     */
    private List<NamespaceInner> value;

    /*
     * A link for the next page of namespaces.
     */
    private String nextLink;

    /**
     * Creates an instance of NamespacesListResult class.
     */
    public NamespacesListResult() {
    }

    /**
     * Get the value property: A collection of namespaces.
     * 
     * @return the value value.
     */
    public List<NamespaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of namespaces.
     * 
     * @param value the value value to set.
     * @return the NamespacesListResult object itself.
     */
    public NamespacesListResult withValue(List<NamespaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of namespaces.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of namespaces.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NamespacesListResult object itself.
     */
    public NamespacesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespacesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespacesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespacesListResult.
     */
    public static NamespacesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespacesListResult deserializedNamespacesListResult = new NamespacesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NamespaceInner> value = reader.readArray(reader1 -> NamespaceInner.fromJson(reader1));
                    deserializedNamespacesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNamespacesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespacesListResult;
        });
    }
}
