// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.resourcemanager.eventgrid.fluent.models.OperationInner;

/**
 * An immutable client-side representation of Operation.
 */
public interface Operation {
    /**
     * Gets the name property: Name of the operation.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the display property: Display name of the operation.
     * 
     * @return the display value.
     */
    OperationInfo display();

    /**
     * Gets the origin property: Origin of the operation.
     * 
     * @return the origin value.
     */
    String origin();

    /**
     * Gets the isDataAction property: This Boolean is used to determine if the operation is a data plane action or not.
     * 
     * @return the isDataAction value.
     */
    Boolean isDataAction();

    /**
     * Gets the properties property: Properties of the operation.
     * 
     * @return the properties value.
     */
    Object properties();

    /**
     * Gets the inner com.azure.resourcemanager.eventgrid.fluent.models.OperationInner object.
     * 
     * @return the inner object.
     */
    OperationInner innerModel();
}
