// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about an operation.
 */
@Fluent
public final class OperationInfo implements JsonSerializable<OperationInfo> {
    /*
     * Name of the provider
     */
    private String provider;

    /*
     * Name of the resource type
     */
    private String resource;

    /*
     * Name of the operation
     */
    private String operation;

    /*
     * Description of the operation
     */
    private String description;

    /**
     * Creates an instance of OperationInfo class.
     */
    public OperationInfo() {
    }

    /**
     * Get the provider property: Name of the provider.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: Name of the provider.
     * 
     * @param provider the provider value to set.
     * @return the OperationInfo object itself.
     */
    public OperationInfo withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the resource property: Name of the resource type.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Set the resource property: Name of the resource type.
     * 
     * @param resource the resource value to set.
     * @return the OperationInfo object itself.
     */
    public OperationInfo withResource(String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the operation property: Name of the operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Set the operation property: Name of the operation.
     * 
     * @param operation the operation value to set.
     * @return the OperationInfo object itself.
     */
    public OperationInfo withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Get the description property: Description of the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the operation.
     * 
     * @param description the description value to set.
     * @return the OperationInfo object itself.
     */
    public OperationInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationInfo.
     */
    public static OperationInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationInfo deserializedOperationInfo = new OperationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provider".equals(fieldName)) {
                    deserializedOperationInfo.provider = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedOperationInfo.resource = reader.getString();
                } else if ("operation".equals(fieldName)) {
                    deserializedOperationInfo.operation = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedOperationInfo.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationInfo;
        });
    }
}
