// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The partner authorization details.
 */
@Fluent
public final class PartnerAuthorization implements JsonSerializable<PartnerAuthorization> {
    /*
     * Time used to validate the authorization expiration time for each authorized partner. If
     * DefaultMaximumExpirationTimeInDays is
     * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
     */
    private Integer defaultMaximumExpirationTimeInDays;

    /*
     * The list of authorized partners.
     */
    private List<Partner> authorizedPartnersList;

    /**
     * Creates an instance of PartnerAuthorization class.
     */
    public PartnerAuthorization() {
    }

    /**
     * Get the defaultMaximumExpirationTimeInDays property: Time used to validate the authorization expiration time for
     * each authorized partner. If DefaultMaximumExpirationTimeInDays is
     * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
     * 
     * @return the defaultMaximumExpirationTimeInDays value.
     */
    public Integer defaultMaximumExpirationTimeInDays() {
        return this.defaultMaximumExpirationTimeInDays;
    }

    /**
     * Set the defaultMaximumExpirationTimeInDays property: Time used to validate the authorization expiration time for
     * each authorized partner. If DefaultMaximumExpirationTimeInDays is
     * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
     * 
     * @param defaultMaximumExpirationTimeInDays the defaultMaximumExpirationTimeInDays value to set.
     * @return the PartnerAuthorization object itself.
     */
    public PartnerAuthorization withDefaultMaximumExpirationTimeInDays(Integer defaultMaximumExpirationTimeInDays) {
        this.defaultMaximumExpirationTimeInDays = defaultMaximumExpirationTimeInDays;
        return this;
    }

    /**
     * Get the authorizedPartnersList property: The list of authorized partners.
     * 
     * @return the authorizedPartnersList value.
     */
    public List<Partner> authorizedPartnersList() {
        return this.authorizedPartnersList;
    }

    /**
     * Set the authorizedPartnersList property: The list of authorized partners.
     * 
     * @param authorizedPartnersList the authorizedPartnersList value to set.
     * @return the PartnerAuthorization object itself.
     */
    public PartnerAuthorization withAuthorizedPartnersList(List<Partner> authorizedPartnersList) {
        this.authorizedPartnersList = authorizedPartnersList;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authorizedPartnersList() != null) {
            authorizedPartnersList().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("defaultMaximumExpirationTimeInDays", this.defaultMaximumExpirationTimeInDays);
        jsonWriter.writeArrayField("authorizedPartnersList", this.authorizedPartnersList,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerAuthorization from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerAuthorization if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerAuthorization.
     */
    public static PartnerAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerAuthorization deserializedPartnerAuthorization = new PartnerAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultMaximumExpirationTimeInDays".equals(fieldName)) {
                    deserializedPartnerAuthorization.defaultMaximumExpirationTimeInDays
                        = reader.getNullable(JsonReader::getInt);
                } else if ("authorizedPartnersList".equals(fieldName)) {
                    List<Partner> authorizedPartnersList = reader.readArray(reader1 -> Partner.fromJson(reader1));
                    deserializedPartnerAuthorization.authorizedPartnersList = authorizedPartnersList;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerAuthorization;
        });
    }
}
