// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationUpdateParameterProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of the partner configuration update.
 */
@Fluent
public final class PartnerConfigurationUpdateParameters
    implements JsonSerializable<PartnerConfigurationUpdateParameters> {
    /*
     * Tags of the partner configuration resource.
     */
    private Map<String, String> tags;

    /*
     * Properties of the Topic resource.
     */
    private PartnerConfigurationUpdateParameterProperties innerProperties;

    /**
     * Creates an instance of PartnerConfigurationUpdateParameters class.
     */
    public PartnerConfigurationUpdateParameters() {
    }

    /**
     * Get the tags property: Tags of the partner configuration resource.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags of the partner configuration resource.
     * 
     * @param tags the tags value to set.
     * @return the PartnerConfigurationUpdateParameters object itself.
     */
    public PartnerConfigurationUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the Topic resource.
     * 
     * @return the innerProperties value.
     */
    private PartnerConfigurationUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the defaultMaximumExpirationTimeInDays property: The default time used to validate the maximum expiration
     * time for each authorized partners in days. Allowed values ar between 1 and 365 days.
     * 
     * @return the defaultMaximumExpirationTimeInDays value.
     */
    public Integer defaultMaximumExpirationTimeInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMaximumExpirationTimeInDays();
    }

    /**
     * Set the defaultMaximumExpirationTimeInDays property: The default time used to validate the maximum expiration
     * time for each authorized partners in days. Allowed values ar between 1 and 365 days.
     * 
     * @param defaultMaximumExpirationTimeInDays the defaultMaximumExpirationTimeInDays value to set.
     * @return the PartnerConfigurationUpdateParameters object itself.
     */
    public PartnerConfigurationUpdateParameters
        withDefaultMaximumExpirationTimeInDays(Integer defaultMaximumExpirationTimeInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationUpdateParameterProperties();
        }
        this.innerProperties().withDefaultMaximumExpirationTimeInDays(defaultMaximumExpirationTimeInDays);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerConfigurationUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerConfigurationUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerConfigurationUpdateParameters.
     */
    public static PartnerConfigurationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerConfigurationUpdateParameters deserializedPartnerConfigurationUpdateParameters
                = new PartnerConfigurationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerConfigurationUpdateParameters.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedPartnerConfigurationUpdateParameters.innerProperties
                        = PartnerConfigurationUpdateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerConfigurationUpdateParameters;
        });
    }
}
