// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List partner configurations operation.
 */
@Fluent
public final class PartnerConfigurationsListResult implements JsonSerializable<PartnerConfigurationsListResult> {
    /*
     * A collection of partner configurations.
     */
    private List<PartnerConfigurationInner> value;

    /*
     * A link for the next page of partner configurations.
     */
    private String nextLink;

    /**
     * Creates an instance of PartnerConfigurationsListResult class.
     */
    public PartnerConfigurationsListResult() {
    }

    /**
     * Get the value property: A collection of partner configurations.
     * 
     * @return the value value.
     */
    public List<PartnerConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of partner configurations.
     * 
     * @param value the value value to set.
     * @return the PartnerConfigurationsListResult object itself.
     */
    public PartnerConfigurationsListResult withValue(List<PartnerConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of partner configurations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of partner configurations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PartnerConfigurationsListResult object itself.
     */
    public PartnerConfigurationsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerConfigurationsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerConfigurationsListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerConfigurationsListResult.
     */
    public static PartnerConfigurationsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerConfigurationsListResult deserializedPartnerConfigurationsListResult
                = new PartnerConfigurationsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PartnerConfigurationInner> value
                        = reader.readArray(reader1 -> PartnerConfigurationInner.fromJson(reader1));
                    deserializedPartnerConfigurationsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPartnerConfigurationsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerConfigurationsListResult;
        });
    }
}
