// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerRegistrationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Partner Registrations operation.
 */
@Fluent
public final class PartnerRegistrationsListResult implements JsonSerializable<PartnerRegistrationsListResult> {
    /*
     * A collection of partner registrations.
     */
    private List<PartnerRegistrationInner> value;

    /*
     * A link for the next page of partner registrations.
     */
    private String nextLink;

    /**
     * Creates an instance of PartnerRegistrationsListResult class.
     */
    public PartnerRegistrationsListResult() {
    }

    /**
     * Get the value property: A collection of partner registrations.
     * 
     * @return the value value.
     */
    public List<PartnerRegistrationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of partner registrations.
     * 
     * @param value the value value to set.
     * @return the PartnerRegistrationsListResult object itself.
     */
    public PartnerRegistrationsListResult withValue(List<PartnerRegistrationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of partner registrations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of partner registrations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PartnerRegistrationsListResult object itself.
     */
    public PartnerRegistrationsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerRegistrationsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerRegistrationsListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerRegistrationsListResult.
     */
    public static PartnerRegistrationsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerRegistrationsListResult deserializedPartnerRegistrationsListResult
                = new PartnerRegistrationsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PartnerRegistrationInner> value
                        = reader.readArray(reader1 -> PartnerRegistrationInner.fromJson(reader1));
                    deserializedPartnerRegistrationsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPartnerRegistrationsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerRegistrationsListResult;
        });
    }
}
