// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the corresponding partner topic of a Channel.
 */
@Fluent
public final class PartnerTopicInfo implements JsonSerializable<PartnerTopicInfo> {
    /*
     * Azure subscription ID of the subscriber. The partner topic associated with the channel will be
     * created under this Azure subscription.
     */
    private String azureSubscriptionId;

    /*
     * Azure Resource Group of the subscriber. The partner topic associated with the channel will be
     * created under this resource group.
     */
    private String resourceGroupName;

    /*
     * Name of the partner topic associated with the channel.
     */
    private String name;

    /*
     * Event Type Information for the partner topic. This information is provided by the publisher and can be used by
     * the
     * subscriber to view different types of events that are published.
     */
    private EventTypeInfo eventTypeInfo;

    /*
     * The source information is provided by the publisher to determine the scope or context from which the events
     * are originating. This information can be used by the subscriber during the approval process of the
     * created partner topic.
     */
    private String source;

    /**
     * Creates an instance of PartnerTopicInfo class.
     */
    public PartnerTopicInfo() {
    }

    /**
     * Get the azureSubscriptionId property: Azure subscription ID of the subscriber. The partner topic associated with
     * the channel will be
     * created under this Azure subscription.
     * 
     * @return the azureSubscriptionId value.
     */
    public String azureSubscriptionId() {
        return this.azureSubscriptionId;
    }

    /**
     * Set the azureSubscriptionId property: Azure subscription ID of the subscriber. The partner topic associated with
     * the channel will be
     * created under this Azure subscription.
     * 
     * @param azureSubscriptionId the azureSubscriptionId value to set.
     * @return the PartnerTopicInfo object itself.
     */
    public PartnerTopicInfo withAzureSubscriptionId(String azureSubscriptionId) {
        this.azureSubscriptionId = azureSubscriptionId;
        return this;
    }

    /**
     * Get the resourceGroupName property: Azure Resource Group of the subscriber. The partner topic associated with the
     * channel will be
     * created under this resource group.
     * 
     * @return the resourceGroupName value.
     */
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    /**
     * Set the resourceGroupName property: Azure Resource Group of the subscriber. The partner topic associated with the
     * channel will be
     * created under this resource group.
     * 
     * @param resourceGroupName the resourceGroupName value to set.
     * @return the PartnerTopicInfo object itself.
     */
    public PartnerTopicInfo withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    /**
     * Get the name property: Name of the partner topic associated with the channel.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the partner topic associated with the channel.
     * 
     * @param name the name value to set.
     * @return the PartnerTopicInfo object itself.
     */
    public PartnerTopicInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the eventTypeInfo property: Event Type Information for the partner topic. This information is provided by the
     * publisher and can be used by the
     * subscriber to view different types of events that are published.
     * 
     * @return the eventTypeInfo value.
     */
    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    /**
     * Set the eventTypeInfo property: Event Type Information for the partner topic. This information is provided by the
     * publisher and can be used by the
     * subscriber to view different types of events that are published.
     * 
     * @param eventTypeInfo the eventTypeInfo value to set.
     * @return the PartnerTopicInfo object itself.
     */
    public PartnerTopicInfo withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    /**
     * Get the source property: The source information is provided by the publisher to determine the scope or context
     * from which the events
     * are originating. This information can be used by the subscriber during the approval process of the
     * created partner topic.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: The source information is provided by the publisher to determine the scope or context
     * from which the events
     * are originating. This information can be used by the subscriber during the approval process of the
     * created partner topic.
     * 
     * @param source the source value to set.
     * @return the PartnerTopicInfo object itself.
     */
    public PartnerTopicInfo withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (eventTypeInfo() != null) {
            eventTypeInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureSubscriptionId", this.azureSubscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("eventTypeInfo", this.eventTypeInfo);
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerTopicInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerTopicInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerTopicInfo.
     */
    public static PartnerTopicInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerTopicInfo deserializedPartnerTopicInfo = new PartnerTopicInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureSubscriptionId".equals(fieldName)) {
                    deserializedPartnerTopicInfo.azureSubscriptionId = reader.getString();
                } else if ("resourceGroupName".equals(fieldName)) {
                    deserializedPartnerTopicInfo.resourceGroupName = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPartnerTopicInfo.name = reader.getString();
                } else if ("eventTypeInfo".equals(fieldName)) {
                    deserializedPartnerTopicInfo.eventTypeInfo = EventTypeInfo.fromJson(reader);
                } else if ("source".equals(fieldName)) {
                    deserializedPartnerTopicInfo.source = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerTopicInfo;
        });
    }
}
