// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of the Partner Topic update.
 */
@Fluent
public final class PartnerTopicUpdateParameters implements JsonSerializable<PartnerTopicUpdateParameters> {
    /*
     * Tags of the Partner Topic resource.
     */
    private Map<String, String> tags;

    /*
     * Identity information for the Partner Topic resource.
     */
    private IdentityInfo identity;

    /**
     * Creates an instance of PartnerTopicUpdateParameters class.
     */
    public PartnerTopicUpdateParameters() {
    }

    /**
     * Get the tags property: Tags of the Partner Topic resource.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags of the Partner Topic resource.
     * 
     * @param tags the tags value to set.
     * @return the PartnerTopicUpdateParameters object itself.
     */
    public PartnerTopicUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: Identity information for the Partner Topic resource.
     * 
     * @return the identity value.
     */
    public IdentityInfo identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity information for the Partner Topic resource.
     * 
     * @param identity the identity value to set.
     * @return the PartnerTopicUpdateParameters object itself.
     */
    public PartnerTopicUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerTopicUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerTopicUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerTopicUpdateParameters.
     */
    public static PartnerTopicUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerTopicUpdateParameters deserializedPartnerTopicUpdateParameters = new PartnerTopicUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerTopicUpdateParameters.tags = tags;
                } else if ("identity".equals(fieldName)) {
                    deserializedPartnerTopicUpdateParameters.identity = IdentityInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerTopicUpdateParameters;
        });
    }
}
