// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Update properties for the corresponding partner topic of a channel.
 */
@Fluent
public final class PartnerUpdateTopicInfo implements JsonSerializable<PartnerUpdateTopicInfo> {
    /*
     * Event type info for the partner topic
     */
    private EventTypeInfo eventTypeInfo;

    /**
     * Creates an instance of PartnerUpdateTopicInfo class.
     */
    public PartnerUpdateTopicInfo() {
    }

    /**
     * Get the eventTypeInfo property: Event type info for the partner topic.
     * 
     * @return the eventTypeInfo value.
     */
    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    /**
     * Set the eventTypeInfo property: Event type info for the partner topic.
     * 
     * @param eventTypeInfo the eventTypeInfo value to set.
     * @return the PartnerUpdateTopicInfo object itself.
     */
    public PartnerUpdateTopicInfo withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (eventTypeInfo() != null) {
            eventTypeInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("eventTypeInfo", this.eventTypeInfo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerUpdateTopicInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerUpdateTopicInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerUpdateTopicInfo.
     */
    public static PartnerUpdateTopicInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerUpdateTopicInfo deserializedPartnerUpdateTopicInfo = new PartnerUpdateTopicInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedPartnerUpdateTopicInfo.eventTypeInfo = EventTypeInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerUpdateTopicInfo;
        });
    }
}
