// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PermissionBindingInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Permission Binding operation.
 */
@Fluent
public final class PermissionBindingsListResult implements JsonSerializable<PermissionBindingsListResult> {
    /*
     * A collection of Permission Binding.
     */
    private List<PermissionBindingInner> value;

    /*
     * A link for the next page of Permission Binding.
     */
    private String nextLink;

    /**
     * Creates an instance of PermissionBindingsListResult class.
     */
    public PermissionBindingsListResult() {
    }

    /**
     * Get the value property: A collection of Permission Binding.
     * 
     * @return the value value.
     */
    public List<PermissionBindingInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Permission Binding.
     * 
     * @param value the value value to set.
     * @return the PermissionBindingsListResult object itself.
     */
    public PermissionBindingsListResult withValue(List<PermissionBindingInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of Permission Binding.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of Permission Binding.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PermissionBindingsListResult object itself.
     */
    public PermissionBindingsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PermissionBindingsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PermissionBindingsListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PermissionBindingsListResult.
     */
    public static PermissionBindingsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PermissionBindingsListResult deserializedPermissionBindingsListResult = new PermissionBindingsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PermissionBindingInner> value
                        = reader.readArray(reader1 -> PermissionBindingInner.fromJson(reader1));
                    deserializedPermissionBindingsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPermissionBindingsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPermissionBindingsListResult;
        });
    }
}
