// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The allowed permission.
 */
public final class PermissionType extends ExpandableStringEnum<PermissionType> {
    /**
     * Static value Publisher for PermissionType.
     */
    public static final PermissionType PUBLISHER = fromString("Publisher");

    /**
     * Static value Subscriber for PermissionType.
     */
    public static final PermissionType SUBSCRIBER = fromString("Subscriber");

    /**
     * Creates a new instance of PermissionType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PermissionType() {
    }

    /**
     * Creates or finds a PermissionType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PermissionType.
     */
    public static PermissionType fromString(String name) {
        return fromString(name, PermissionType.class);
    }

    /**
     * Gets known PermissionType values.
     * 
     * @return known PermissionType values.
     */
    public static Collection<PermissionType> values() {
        return values(PermissionType.class);
    }
}
