// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import java.util.List;

/**
 * An immutable client-side representation of PrivateEndpointConnection.
 */
public interface PrivateEndpointConnection {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the privateEndpoint property: The Private Endpoint resource for this Connection.
     * 
     * @return the privateEndpoint value.
     */
    PrivateEndpoint privateEndpoint();

    /**
     * Gets the groupIds property: GroupIds from the private link service resource.
     * 
     * @return the groupIds value.
     */
    List<String> groupIds();

    /**
     * Gets the privateLinkServiceConnectionState property: Details about the state of the connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    ConnectionState privateLinkServiceConnectionState();

    /**
     * Gets the provisioningState property: Provisioning state of the Private Endpoint Connection.
     * 
     * @return the provisioningState value.
     */
    ResourceProvisioningState provisioningState();

    /**
     * Gets the inner com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner object.
     * 
     * @return the inner object.
     */
    PrivateEndpointConnectionInner innerModel();
}
