// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The readiness state of the corresponding partner topic.
 */
public final class ReadinessState extends ExpandableStringEnum<ReadinessState> {
    /**
     * Static value NeverActivated for ReadinessState.
     */
    public static final ReadinessState NEVER_ACTIVATED = fromString("NeverActivated");

    /**
     * Static value Activated for ReadinessState.
     */
    public static final ReadinessState ACTIVATED = fromString("Activated");

    /**
     * Creates a new instance of ReadinessState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReadinessState() {
    }

    /**
     * Creates or finds a ReadinessState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ReadinessState.
     */
    public static ReadinessState fromString(String name) {
        return fromString(name, ReadinessState.class);
    }

    /**
     * Gets known ReadinessState values.
     * 
     * @return known ReadinessState values.
     */
    public static Collection<ReadinessState> values() {
        return values(ReadinessState.class);
    }
}
