// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The RoutingEnrichments model.
 */
@Fluent
public final class RoutingEnrichments implements JsonSerializable<RoutingEnrichments> {
    /*
     * The static property.
     */
    private List<StaticRoutingEnrichment> staticProperty;

    /*
     * The dynamic property.
     */
    private List<DynamicRoutingEnrichment> dynamic;

    /**
     * Creates an instance of RoutingEnrichments class.
     */
    public RoutingEnrichments() {
    }

    /**
     * Get the staticProperty property: The static property.
     * 
     * @return the staticProperty value.
     */
    public List<StaticRoutingEnrichment> staticProperty() {
        return this.staticProperty;
    }

    /**
     * Set the staticProperty property: The static property.
     * 
     * @param staticProperty the staticProperty value to set.
     * @return the RoutingEnrichments object itself.
     */
    public RoutingEnrichments withStaticProperty(List<StaticRoutingEnrichment> staticProperty) {
        this.staticProperty = staticProperty;
        return this;
    }

    /**
     * Get the dynamic property: The dynamic property.
     * 
     * @return the dynamic value.
     */
    public List<DynamicRoutingEnrichment> dynamic() {
        return this.dynamic;
    }

    /**
     * Set the dynamic property: The dynamic property.
     * 
     * @param dynamic the dynamic value to set.
     * @return the RoutingEnrichments object itself.
     */
    public RoutingEnrichments withDynamic(List<DynamicRoutingEnrichment> dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (staticProperty() != null) {
            staticProperty().forEach(e -> e.validate());
        }
        if (dynamic() != null) {
            dynamic().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("static", this.staticProperty, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("dynamic", this.dynamic, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingEnrichments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingEnrichments if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoutingEnrichments.
     */
    public static RoutingEnrichments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingEnrichments deserializedRoutingEnrichments = new RoutingEnrichments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("static".equals(fieldName)) {
                    List<StaticRoutingEnrichment> staticProperty
                        = reader.readArray(reader1 -> StaticRoutingEnrichment.fromJson(reader1));
                    deserializedRoutingEnrichments.staticProperty = staticProperty;
                } else if ("dynamic".equals(fieldName)) {
                    List<DynamicRoutingEnrichment> dynamic
                        = reader.readArray(reader1 -> DynamicRoutingEnrichment.fromJson(reader1));
                    deserializedRoutingEnrichments.dynamic = dynamic;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingEnrichments;
        });
    }
}
