// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Routing identity info for topic spaces configuration.
 */
@Fluent
public final class RoutingIdentityInfo implements JsonSerializable<RoutingIdentityInfo> {
    /*
     * Routing identity type for topic spaces configuration.
     */
    private RoutingIdentityType type;

    /*
     * The userAssignedIdentity property.
     */
    private String userAssignedIdentity;

    /**
     * Creates an instance of RoutingIdentityInfo class.
     */
    public RoutingIdentityInfo() {
    }

    /**
     * Get the type property: Routing identity type for topic spaces configuration.
     * 
     * @return the type value.
     */
    public RoutingIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: Routing identity type for topic spaces configuration.
     * 
     * @param type the type value to set.
     * @return the RoutingIdentityInfo object itself.
     */
    public RoutingIdentityInfo withType(RoutingIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentity property: The userAssignedIdentity property.
     * 
     * @return the userAssignedIdentity value.
     */
    public String userAssignedIdentity() {
        return this.userAssignedIdentity;
    }

    /**
     * Set the userAssignedIdentity property: The userAssignedIdentity property.
     * 
     * @param userAssignedIdentity the userAssignedIdentity value to set.
     * @return the RoutingIdentityInfo object itself.
     */
    public RoutingIdentityInfo withUserAssignedIdentity(String userAssignedIdentity) {
        this.userAssignedIdentity = userAssignedIdentity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("userAssignedIdentity", this.userAssignedIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingIdentityInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingIdentityInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoutingIdentityInfo.
     */
    public static RoutingIdentityInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingIdentityInfo deserializedRoutingIdentityInfo = new RoutingIdentityInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedRoutingIdentityInfo.type = RoutingIdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentity".equals(fieldName)) {
                    deserializedRoutingIdentityInfo.userAssignedIdentity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingIdentityInfo;
        });
    }
}
