// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.StaticDeliveryAttributeMappingProperties;
import java.io.IOException;

/**
 * Static delivery attribute mapping details.
 */
@Fluent
public final class StaticDeliveryAttributeMapping extends DeliveryAttributeMapping {
    /*
     * Type of the delivery attribute or header name.
     */
    private DeliveryAttributeMappingType type = DeliveryAttributeMappingType.STATIC;

    /*
     * Properties of static delivery attribute mapping.
     */
    private StaticDeliveryAttributeMappingProperties innerProperties;

    /**
     * Creates an instance of StaticDeliveryAttributeMapping class.
     */
    public StaticDeliveryAttributeMapping() {
    }

    /**
     * Get the type property: Type of the delivery attribute or header name.
     * 
     * @return the type value.
     */
    @Override
    public DeliveryAttributeMappingType type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Properties of static delivery attribute mapping.
     * 
     * @return the innerProperties value.
     */
    StaticDeliveryAttributeMappingProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticDeliveryAttributeMapping withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * Get the value property: Value of the delivery attribute.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Value of the delivery attribute.
     * 
     * @param value the value value to set.
     * @return the StaticDeliveryAttributeMapping object itself.
     */
    public StaticDeliveryAttributeMapping withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticDeliveryAttributeMappingProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the isSecret property: Boolean flag to tell if the attribute contains sensitive information .
     * 
     * @return the isSecret value.
     */
    public Boolean isSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().isSecret();
    }

    /**
     * Set the isSecret property: Boolean flag to tell if the attribute contains sensitive information .
     * 
     * @param isSecret the isSecret value to set.
     * @return the StaticDeliveryAttributeMapping object itself.
     */
    public StaticDeliveryAttributeMapping withIsSecret(Boolean isSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticDeliveryAttributeMappingProperties();
        }
        this.innerProperties().withIsSecret(isSecret);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticDeliveryAttributeMapping from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticDeliveryAttributeMapping if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticDeliveryAttributeMapping.
     */
    public static StaticDeliveryAttributeMapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticDeliveryAttributeMapping deserializedStaticDeliveryAttributeMapping
                = new StaticDeliveryAttributeMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.withName(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.type
                        = DeliveryAttributeMappingType.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.innerProperties
                        = StaticDeliveryAttributeMappingProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticDeliveryAttributeMapping;
        });
    }
}
