// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The StaticStringRoutingEnrichment model.
 */
@Fluent
public final class StaticStringRoutingEnrichment extends StaticRoutingEnrichment {
    /*
     * Static routing enrichment value type. For e.g. this property value can be 'String'.
     */
    private StaticRoutingEnrichmentType valueType = StaticRoutingEnrichmentType.STRING;

    /*
     * String type routing enrichment value.
     */
    private String value;

    /**
     * Creates an instance of StaticStringRoutingEnrichment class.
     */
    public StaticStringRoutingEnrichment() {
    }

    /**
     * Get the valueType property: Static routing enrichment value type. For e.g. this property value can be 'String'.
     * 
     * @return the valueType value.
     */
    @Override
    public StaticRoutingEnrichmentType valueType() {
        return this.valueType;
    }

    /**
     * Get the value property: String type routing enrichment value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: String type routing enrichment value.
     * 
     * @param value the value value to set.
     * @return the StaticStringRoutingEnrichment object itself.
     */
    public StaticStringRoutingEnrichment withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticStringRoutingEnrichment withKey(String key) {
        super.withKey(key);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", key());
        jsonWriter.writeStringField("valueType", this.valueType == null ? null : this.valueType.toString());
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticStringRoutingEnrichment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticStringRoutingEnrichment if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticStringRoutingEnrichment.
     */
    public static StaticStringRoutingEnrichment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticStringRoutingEnrichment deserializedStaticStringRoutingEnrichment
                = new StaticStringRoutingEnrichment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.withKey(reader.getString());
                } else if ("valueType".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.valueType
                        = StaticRoutingEnrichmentType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticStringRoutingEnrichment;
        });
    }
}
