// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.StorageBlobDeadLetterDestinationProperties;
import java.io.IOException;

/**
 * Information about the storage blob based dead letter destination.
 */
@Fluent
public final class StorageBlobDeadLetterDestination extends DeadLetterDestination {
    /*
     * Type of the endpoint for the dead letter destination
     */
    private DeadLetterEndPointType endpointType = DeadLetterEndPointType.STORAGE_BLOB;

    /*
     * The properties of the Storage Blob based deadletter destination
     */
    private StorageBlobDeadLetterDestinationProperties innerProperties;

    /**
     * Creates an instance of StorageBlobDeadLetterDestination class.
     */
    public StorageBlobDeadLetterDestination() {
    }

    /**
     * Get the endpointType property: Type of the endpoint for the dead letter destination.
     * 
     * @return the endpointType value.
     */
    @Override
    public DeadLetterEndPointType endpointType() {
        return this.endpointType;
    }

    /**
     * Get the innerProperties property: The properties of the Storage Blob based deadletter destination.
     * 
     * @return the innerProperties value.
     */
    StorageBlobDeadLetterDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resourceId property: The Azure Resource ID of the storage account that is the destination of the
     * deadletter events.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: The Azure Resource ID of the storage account that is the destination of the
     * deadletter events.
     * 
     * @param resourceId the resourceId value to set.
     * @return the StorageBlobDeadLetterDestination object itself.
     */
    public StorageBlobDeadLetterDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageBlobDeadLetterDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the blobContainerName property: The name of the Storage blob container that is the destination of the
     * deadletter events.
     * 
     * @return the blobContainerName value.
     */
    public String blobContainerName() {
        return this.innerProperties() == null ? null : this.innerProperties().blobContainerName();
    }

    /**
     * Set the blobContainerName property: The name of the Storage blob container that is the destination of the
     * deadletter events.
     * 
     * @param blobContainerName the blobContainerName value to set.
     * @return the StorageBlobDeadLetterDestination object itself.
     */
    public StorageBlobDeadLetterDestination withBlobContainerName(String blobContainerName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageBlobDeadLetterDestinationProperties();
        }
        this.innerProperties().withBlobContainerName(blobContainerName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageBlobDeadLetterDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageBlobDeadLetterDestination if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageBlobDeadLetterDestination.
     */
    public static StorageBlobDeadLetterDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageBlobDeadLetterDestination deserializedStorageBlobDeadLetterDestination
                = new StorageBlobDeadLetterDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpointType".equals(fieldName)) {
                    deserializedStorageBlobDeadLetterDestination.endpointType
                        = DeadLetterEndPointType.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStorageBlobDeadLetterDestination.innerProperties
                        = StorageBlobDeadLetterDestinationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageBlobDeadLetterDestination;
        });
    }
}
