// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of the System Topic update.
 */
@Fluent
public final class SystemTopicUpdateParameters implements JsonSerializable<SystemTopicUpdateParameters> {
    /*
     * Tags of the system topic.
     */
    private Map<String, String> tags;

    /*
     * Resource identity information.
     */
    private IdentityInfo identity;

    /**
     * Creates an instance of SystemTopicUpdateParameters class.
     */
    public SystemTopicUpdateParameters() {
    }

    /**
     * Get the tags property: Tags of the system topic.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags of the system topic.
     * 
     * @param tags the tags value to set.
     * @return the SystemTopicUpdateParameters object itself.
     */
    public SystemTopicUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: Resource identity information.
     * 
     * @return the identity value.
     */
    public IdentityInfo identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Resource identity information.
     * 
     * @param identity the identity value to set.
     * @return the SystemTopicUpdateParameters object itself.
     */
    public SystemTopicUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SystemTopicUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SystemTopicUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SystemTopicUpdateParameters.
     */
    public static SystemTopicUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SystemTopicUpdateParameters deserializedSystemTopicUpdateParameters = new SystemTopicUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSystemTopicUpdateParameters.tags = tags;
                } else if ("identity".equals(fieldName)) {
                    deserializedSystemTopicUpdateParameters.identity = IdentityInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSystemTopicUpdateParameters;
        });
    }
}
