// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List System topics operation.
 */
@Fluent
public final class SystemTopicsListResult implements JsonSerializable<SystemTopicsListResult> {
    /*
     * A collection of system Topics.
     */
    private List<SystemTopicInner> value;

    /*
     * A link for the next page of topics.
     */
    private String nextLink;

    /**
     * Creates an instance of SystemTopicsListResult class.
     */
    public SystemTopicsListResult() {
    }

    /**
     * Get the value property: A collection of system Topics.
     * 
     * @return the value value.
     */
    public List<SystemTopicInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of system Topics.
     * 
     * @param value the value value to set.
     * @return the SystemTopicsListResult object itself.
     */
    public SystemTopicsListResult withValue(List<SystemTopicInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of topics.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of topics.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SystemTopicsListResult object itself.
     */
    public SystemTopicsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SystemTopicsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SystemTopicsListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SystemTopicsListResult.
     */
    public static SystemTopicsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SystemTopicsListResult deserializedSystemTopicsListResult = new SystemTopicsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SystemTopicInner> value = reader.readArray(reader1 -> SystemTopicInner.fromJson(reader1));
                    deserializedSystemTopicsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSystemTopicsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSystemTopicsListResult;
        });
    }
}
